/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.propagation;

import java.util.Map;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.PrivacyUtils;
import org.apache.sysds.runtime.privacy.finegrained.DataRange;
import org.apache.sysds.runtime.privacy.propagation.OperatorType;
import org.apache.sysds.runtime.privacy.propagation.PrivacyPropagator;
import org.apache.sysds.runtime.privacy.propagation.PropagatorMultiReturn;

public class ListRemovePropagator
implements PropagatorMultiReturn {
    private final ScalarObject removePosition;
    private final PrivacyConstraint removePositionPrivacyConstraint;
    private final ListObject list;
    private final PrivacyConstraint listPrivacyConstraint;

    public ListRemovePropagator(ListObject list, PrivacyConstraint listPrivacyConstraint, ScalarObject removePosition, PrivacyConstraint removePositionPrivacyConstraint) {
        this.list = list;
        this.listPrivacyConstraint = listPrivacyConstraint;
        this.removePosition = removePosition;
        this.removePositionPrivacyConstraint = removePositionPrivacyConstraint;
    }

    @Override
    public PrivacyConstraint[] propagate() {
        PrivacyConstraint output1PrivacyConstraint = new PrivacyConstraint();
        PrivacyConstraint output2PrivacyConstraint = new PrivacyConstraint();
        this.propagateGeneralConstraints(output1PrivacyConstraint, output2PrivacyConstraint);
        this.propagateFineGrainedConstraints(output1PrivacyConstraint, output2PrivacyConstraint);
        return new PrivacyConstraint[]{output1PrivacyConstraint, output2PrivacyConstraint};
    }

    private void propagateFineGrainedConstraints(PrivacyConstraint output1PrivacyConstraint, PrivacyConstraint output2PrivacyConstraint) {
        if (PrivacyUtils.privacyConstraintFineGrainedActivated(this.listPrivacyConstraint)) {
            this.propagateFirstHalf(output1PrivacyConstraint);
            this.propagateSecondHalf(output1PrivacyConstraint);
            this.propagateRemovedElement(output2PrivacyConstraint);
        }
    }

    private void propagateFirstHalf(PrivacyConstraint output1PrivacyConstraint) {
        long[] newEndDimension = new long[]{this.removePosition.getLongValue() - 2L};
        Map<DataRange, PrivacyConstraint.PrivacyLevel> output1Ranges = this.listPrivacyConstraint.getFineGrainedPrivacy().getPrivacyLevel(new DataRange(new long[]{0L}, newEndDimension));
        output1Ranges.forEach((range, privacyLevel) -> {
            long endDim = Long.min(range.getEndDims()[0], this.removePosition.getLongValue() - 2L);
            DataRange cappedRange = new DataRange(range.getBeginDims(), new long[]{endDim});
            output1PrivacyConstraint.getFineGrainedPrivacy().put(cappedRange, (PrivacyConstraint.PrivacyLevel)((Object)privacyLevel));
        });
    }

    private void propagateSecondHalf(PrivacyConstraint output1PrivacyConstraint) {
        Map<DataRange, PrivacyConstraint.PrivacyLevel> output2Ranges = this.listPrivacyConstraint.getFineGrainedPrivacy().getPrivacyLevel(new DataRange(new long[]{this.removePosition.getLongValue()}, new long[]{this.list.getLength()}));
        output2Ranges.forEach((range, privacyLevel) -> {
            long[] beginDims = new long[]{range.getBeginDims()[0] - 1L};
            long[] endDims = new long[]{range.getEndDims()[0] - 1L};
            output1PrivacyConstraint.getFineGrainedPrivacy().put(new DataRange(beginDims, endDims), (PrivacyConstraint.PrivacyLevel)((Object)privacyLevel));
        });
    }

    private void propagateRemovedElement(PrivacyConstraint output2PrivacyConstraint) {
        if (output2PrivacyConstraint.getPrivacyLevel() != PrivacyConstraint.PrivacyLevel.Private) {
            Map<DataRange, PrivacyConstraint.PrivacyLevel> elementPrivacy = this.listPrivacyConstraint.getFineGrainedPrivacy().getPrivacyLevelOfElement(new long[]{this.removePosition.getLongValue() - 1L});
            if (elementPrivacy.containsValue((Object)PrivacyConstraint.PrivacyLevel.Private)) {
                output2PrivacyConstraint.setPrivacyLevel(PrivacyConstraint.PrivacyLevel.Private);
            } else if (elementPrivacy.containsValue((Object)PrivacyConstraint.PrivacyLevel.PrivateAggregation)) {
                output2PrivacyConstraint.setPrivacyLevel(PrivacyConstraint.PrivacyLevel.PrivateAggregation);
            }
        }
    }

    private void propagateGeneralConstraints(PrivacyConstraint output1PrivacyConstraint, PrivacyConstraint output2PrivacyConstraint) {
        PrivacyConstraint.PrivacyLevel[] inputPrivacyLevels = PrivacyUtils.getGeneralPrivacyLevels(new PrivacyConstraint[]{this.listPrivacyConstraint, this.removePositionPrivacyConstraint});
        PrivacyConstraint.PrivacyLevel outputPrivacyLevel = PrivacyPropagator.corePropagation(inputPrivacyLevels, OperatorType.NonAggregate);
        output1PrivacyConstraint.setPrivacyLevel(outputPrivacyLevel);
        output2PrivacyConstraint.setPrivacyLevel(outputPrivacyLevel);
    }
}

