/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api.mlcontext;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.sysds.api.mlcontext.MLContextConversionUtil;
import org.apache.sysds.api.mlcontext.MLContextException;
import org.apache.sysds.api.mlcontext.MatrixMetadata;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class Matrix {
    private MatrixObject matrixObject;
    private SparkExecutionContext sparkExecutionContext;
    private JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks;
    private MatrixMetadata matrixMetadata;

    public Matrix(MatrixObject matrixObject, SparkExecutionContext sparkExecutionContext) {
        this.matrixObject = matrixObject;
        this.sparkExecutionContext = sparkExecutionContext;
        this.matrixMetadata = new MatrixMetadata(matrixObject.getDataCharacteristics());
    }

    public Matrix(Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        this.matrixMetadata = matrixMetadata;
        this.binaryBlocks = MLContextConversionUtil.dataFrameToMatrixBinaryBlocks(dataFrame, matrixMetadata);
    }

    public Matrix(Dataset<Row> dataFrame, long numRows, long numCols) {
        this(dataFrame, new MatrixMetadata((Long)numRows, (Long)numCols, (Integer)ConfigurationManager.getBlocksize()));
    }

    public Matrix(JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks, MatrixMetadata matrixMetadata) {
        this.binaryBlocks = binaryBlocks;
        this.matrixMetadata = matrixMetadata;
    }

    public Matrix(Dataset<Row> dataFrame) {
        this(dataFrame, new MatrixMetadata());
    }

    public MatrixObject toMatrixObject() {
        return this.matrixObject;
    }

    public double[][] to2DDoubleArray() {
        return MLContextConversionUtil.matrixObjectTo2DDoubleArray(this.matrixObject);
    }

    public JavaRDD<String> toJavaRDDStringIJV() {
        return MLContextConversionUtil.matrixObjectToJavaRDDStringIJV(this.matrixObject);
    }

    public JavaRDD<String> toJavaRDDStringCSV() {
        return MLContextConversionUtil.matrixObjectToJavaRDDStringCSV(this.matrixObject);
    }

    public RDD<String> toRDDStringCSV() {
        return MLContextConversionUtil.matrixObjectToRDDStringCSV(this.matrixObject);
    }

    public RDD<String> toRDDStringIJV() {
        return MLContextConversionUtil.matrixObjectToRDDStringIJV(this.matrixObject);
    }

    public Dataset<Row> toDF() {
        return MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, false);
    }

    public Dataset<Row> toDFDoubleWithIDColumn() {
        return MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, false);
    }

    public Dataset<Row> toDFDoubleNoIDColumn() {
        Dataset<Row> df = MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, false);
        return df.drop("__INDEX");
    }

    public Dataset<Row> toDFVectorWithIDColumn() {
        return MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, true);
    }

    public Dataset<Row> toDFVectorNoIDColumn() {
        Dataset<Row> df = MLContextConversionUtil.matrixObjectToDataFrame(this.matrixObject, this.sparkExecutionContext, true);
        return df.drop("__INDEX");
    }

    public JavaPairRDD<MatrixIndexes, MatrixBlock> toBinaryBlocks() {
        if (this.binaryBlocks != null) {
            return this.binaryBlocks;
        }
        if (this.matrixObject != null) {
            this.binaryBlocks = MLContextConversionUtil.matrixObjectToBinaryBlocks(this.matrixObject, this.sparkExecutionContext);
            DataCharacteristics mc = this.matrixObject.getDataCharacteristics();
            this.matrixMetadata = new MatrixMetadata(mc);
            return this.binaryBlocks;
        }
        throw new MLContextException("No binary blocks or MatrixObject found");
    }

    public MatrixBlock toMatrixBlock() {
        if (this.matrixMetadata == null) {
            throw new MLContextException("Matrix metadata required to convert binary blocks to a MatrixBlock.");
        }
        if (this.binaryBlocks != null) {
            return MLContextConversionUtil.binaryBlocksToMatrixBlock(this.binaryBlocks, this.matrixMetadata);
        }
        if (this.matrixObject != null) {
            return MLContextConversionUtil.binaryBlocksToMatrixBlock(this.toBinaryBlocks(), this.matrixMetadata);
        }
        throw new MLContextException("No binary blocks or MatrixObject found");
    }

    public MatrixMetadata getMatrixMetadata() {
        return this.matrixMetadata;
    }

    public String toString() {
        if (this.matrixObject != null) {
            return this.matrixObject.toString();
        }
        if (this.matrixMetadata != null) {
            return this.matrixMetadata.toString();
        }
        return super.toString();
    }

    public boolean hasBinaryBlocks() {
        return this.binaryBlocks != null;
    }

    public boolean hasMatrixObject() {
        return this.matrixObject != null;
    }
}

