/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CLALibReExpand {
    public static MatrixBlock reExpand(CompressedMatrixBlock in, MatrixBlock ret, double max, boolean cast, boolean ignore, int k) {
        int iMax = UtilFunctions.toInt(max);
        if (!ignore && in.min() == 0.0) {
            throw new DMLRuntimeException("Invalid input w/ zeros for rexpand ignore=false (rlen=" + in.getNumRows() + ", nnz=" + in.getNonZeros() + ").");
        }
        if (in.isOverlapping() || in.getColGroups().size() > 1) {
            throw new DMLRuntimeException("Invalid input for re expand operations, currently not supporting overlapping or multi column groups");
        }
        if (in.isEmptyBlock(false)) {
            ret.reset(in.getNumRows(), iMax, true);
            return ret;
        }
        CompressedMatrixBlock retC = ret instanceof CompressedMatrixBlock ? (CompressedMatrixBlock)ret : new CompressedMatrixBlock(in.getNumRows(), iMax);
        return CLALibReExpand.reExpandRows(in, retC, iMax, cast, k);
    }

    private static CompressedMatrixBlock reExpandRows(CompressedMatrixBlock in, CompressedMatrixBlock ret, int max, boolean cast, int k) {
        ColGroupValue oldGroup = (ColGroupValue)in.getColGroups().get(0);
        ADictionary newDictionary = oldGroup.getDictionary().reExpandColumns(max);
        AColGroup newGroup = oldGroup.copyAndSet(CLALibReExpand.getColIndexes(max), newDictionary);
        ArrayList<AColGroup> newColGroups = new ArrayList<AColGroup>(1);
        newColGroups.add(newGroup);
        ret.allocateColGroupList(newColGroups);
        ret.setOverlapping(true);
        ret.recomputeNonZeros();
        return ret;
    }

    private static int[] getColIndexes(int max) {
        int[] ret = new int[max];
        for (int i = 0; i < max; ++i) {
            ret[i] = i;
        }
        return ret;
    }
}

