/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.cocode.PlanningCoCoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.estim.sample.SampleEstimatorFactory;

public class CompressionSettings {
    private static final Log LOG = LogFactory.getLog((String)CompressionSettings.class.getName());
    public static final int BITMAP_BLOCK_SZ = 65535;
    public final boolean sortValuesByLength;
    public final double samplingRatio;
    public final boolean allowSharedDictionary;
    public final String transposeInput;
    public boolean transposed = false;
    public final boolean skipList;
    public final int seed;
    public final boolean lossy;
    public final PlanningCoCoder.PartitionerType columnPartitioner;
    public final int maxColGroupCoCode;
    public final double coCodePercentage;
    public final EnumSet<AColGroup.CompressionType> validCompressions;
    public final int minimumSampleSize;
    public final SampleEstimatorFactory.EstimationType estimationType;

    protected CompressionSettings(double samplingRatio, boolean allowSharedDictionary, String transposeInput, boolean skipList, int seed, boolean lossy, EnumSet<AColGroup.CompressionType> validCompressions, boolean sortValuesByLength, PlanningCoCoder.PartitionerType columnPartitioner, int maxColGroupCoCode, double coCodePercentage, int minimumSampleSize, SampleEstimatorFactory.EstimationType estimationType) {
        this.samplingRatio = samplingRatio;
        this.allowSharedDictionary = allowSharedDictionary;
        this.transposeInput = transposeInput;
        this.skipList = skipList;
        this.seed = seed;
        this.validCompressions = validCompressions;
        this.lossy = lossy;
        this.sortValuesByLength = sortValuesByLength;
        this.columnPartitioner = columnPartitioner;
        this.maxColGroupCoCode = maxColGroupCoCode;
        this.coCodePercentage = coCodePercentage;
        this.minimumSampleSize = minimumSampleSize;
        this.estimationType = estimationType;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + super.toString());
        sb.append("\n Valid Compressions: " + this.validCompressions);
        sb.append("\n DDC1 share dict: " + this.allowSharedDictionary);
        sb.append("\n Partitioner: " + (Object)((Object)this.columnPartitioner));
        sb.append("\n Lossy: " + this.lossy);
        sb.append("\n sortValuesByLength: " + this.sortValuesByLength);
        sb.append("\n column Partitioner: " + (Object)((Object)this.columnPartitioner));
        sb.append("\n Max Static ColGroup CoCode: " + this.maxColGroupCoCode);
        sb.append("\n Max cocodePercentage: " + this.coCodePercentage);
        sb.append("\n Sample Percentage: " + this.samplingRatio);
        if (this.samplingRatio < 1.0) {
            sb.append("\n Estimation Type: " + (Object)((Object)this.estimationType));
        }
        return sb.toString();
    }
}

