/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.util.NormalPRNGenerator;
import org.apache.sysds.runtime.util.PRNGenerator;
import org.apache.sysds.runtime.util.PoissonPRNGenerator;
import org.apache.sysds.runtime.util.UniformPRNGenerator;

public class RandomMatrixGenerator {
    PDF _pdf;
    int _rows;
    int _cols;
    int _blocksize;
    double _sparsity;
    double _mean;
    double _min;
    double _max;
    PRNGenerator _valuePRNG;

    public RandomMatrixGenerator() {
        this._pdf = PDF.UNIFORM;
        this._blocksize = -1;
        this._cols = -1;
        this._rows = -1;
        this._sparsity = 0.0;
        this._max = Double.NaN;
        this._min = Double.NaN;
        this._valuePRNG = null;
        this._mean = 1.0;
    }

    public RandomMatrixGenerator(PDF pdf, int r, int c, int blen, double sp) {
        this(pdf, r, c, blen, sp, Double.NaN, Double.NaN);
    }

    public RandomMatrixGenerator(String pdfStr, int r, int c, int blen, double sp, double min, double max) {
        this.init(PDF.valueOf(pdfStr.toUpperCase()), r, c, blen, sp, min, max);
    }

    public RandomMatrixGenerator(PDF pdf, int r, int c, int blen, double sp, double min, double max) {
        this.init(pdf, r, c, blen, sp, min, max);
    }

    public void init(PDF pdf, int r, int c, int blen, double sp, double min, double max) {
        this._pdf = pdf;
        this._rows = r;
        this._cols = c;
        this._blocksize = blen;
        this._sparsity = sp;
        this._min = min;
        this._max = max;
        this.setupValuePRNG();
    }

    public RandomMatrixGenerator(PDF pdf, int r, int c, int blen, double sp, double min, double max, double mean) {
        this.init(pdf, r, c, blen, sp, min, max, mean);
    }

    public void init(PDF pdf, int r, int c, int blen, double sp, double min, double max, double mean) {
        this._pdf = pdf;
        this._rows = r;
        this._cols = c;
        this._blocksize = blen;
        this._sparsity = sp;
        this._min = min;
        this._max = max;
        this._mean = mean;
        this.setupValuePRNG();
    }

    protected void setupValuePRNG() {
        switch (this._pdf) {
            case NORMAL: {
                this._valuePRNG = new NormalPRNGenerator();
                break;
            }
            case UNIFORM: {
                this._valuePRNG = new UniformPRNGenerator();
                break;
            }
            case POISSON: {
                if (this._mean <= 0.0) {
                    throw new DMLRuntimeException("Invalid parameter (" + this._mean + ") for Poisson distribution.");
                }
                this._valuePRNG = new PoissonPRNGenerator(this._mean);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported probability density function");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PRNG[");
        sb.append("pdf = " + this._pdf.name() + ", ");
        sb.append("rows = " + this._rows + ", ");
        sb.append("cols = " + this._cols + ", ");
        sb.append("blen = " + this._blocksize + ", ");
        sb.append("sparsity = " + this._sparsity + ", ");
        sb.append("min = " + this._min + ", ");
        sb.append("max = " + this._max + "]");
        return sb.toString();
    }

    static enum PDF {
        NORMAL,
        UNIFORM,
        POISSON;

    }
}

