/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.privacy.propagation.PrivacyPropagator;

public abstract class FEDInstruction
extends Instruction {
    protected final FEDType _fedType;
    protected long _tid = -1L;

    protected FEDInstruction(FEDType type, String opcode, String istr) {
        this(type, null, opcode, istr);
    }

    protected FEDInstruction(FEDType type, Operator op, String opcode, String istr) {
        super(op);
        this._fedType = type;
        this.instString = istr;
        this.instOpcode = opcode;
    }

    @Override
    public Instruction.IType getType() {
        return Instruction.IType.FEDERATED;
    }

    public FEDType getFEDInstructionType() {
        return this._fedType;
    }

    public long getTID() {
        return this._tid;
    }

    public void setTID(long tid) {
        this._tid = tid;
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) {
        Instruction tmp = super.preprocessInstruction(ec);
        tmp = PrivacyPropagator.preprocessInstruction(tmp, ec);
        return tmp;
    }

    public static enum FEDType {
        AggregateBinary,
        AggregateUnary,
        Append,
        Binary,
        Init,
        MultiReturnParameterizedBuiltin,
        ParameterizedBuiltin,
        Tsmm,
        MMChain,
        Reorg;

    }
}

