/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LineageCacheEntry {
    protected final LineageItem _key;
    protected final Types.DataType _dt;
    protected MatrixBlock _MBval;
    protected ScalarObject _SOval;
    protected long _computeTime;
    protected long _timestamp = 0L;
    protected LineageCacheConfig.LineageCacheStatus _status;
    protected LineageCacheEntry _nextEntry;
    protected LineageItem _origItem;
    private String _outfile = null;
    protected double score;

    public LineageCacheEntry(LineageItem key, Types.DataType dt, MatrixBlock Mval, ScalarObject Sval, long computetime) {
        this._key = key;
        this._dt = dt;
        this._MBval = Mval;
        this._SOval = Sval;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this._nextEntry = null;
        this._origItem = null;
    }

    protected synchronized void setCacheStatus(LineageCacheConfig.LineageCacheStatus st) {
        this._status = st;
    }

    public synchronized MatrixBlock getMBValue() {
        try {
            while (this._MBval == null) {
                this.wait();
            }
            return this._MBval;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized ScalarObject getSOValue() {
        try {
            while (this._SOval == null) {
                this.wait();
            }
            return this._SOval;
        }
        catch (InterruptedException ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public synchronized LineageCacheConfig.LineageCacheStatus getCacheStatus() {
        return this._status;
    }

    public synchronized long getSize() {
        return (this._MBval != null ? this._MBval.getInMemorySize() : 0L) + (long)(this._SOval != null ? this._SOval.getSize() : 0);
    }

    public boolean isNullVal() {
        return this._MBval == null && this._SOval == null;
    }

    public boolean isMatrixValue() {
        return this._dt.isMatrix();
    }

    public synchronized void setValue(MatrixBlock val, long computetime) {
        this._MBval = val;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this.notifyAll();
    }

    public synchronized void setValue(MatrixBlock val) {
        this.setValue(val, this._computeTime);
    }

    public synchronized void setValue(ScalarObject val, long computetime) {
        this._SOval = val;
        this._computeTime = computetime;
        this._status = this.isNullVal() ? LineageCacheConfig.LineageCacheStatus.EMPTY : LineageCacheConfig.LineageCacheStatus.CACHED;
        this.notifyAll();
    }

    protected synchronized void setNullValues() {
        this._MBval = null;
        this._SOval = null;
        this._status = LineageCacheConfig.LineageCacheStatus.EMPTY;
    }

    protected synchronized void setOutfile(String outfile) {
        this._outfile = outfile;
    }

    protected synchronized String getOutfile() {
        return this._outfile;
    }

    protected synchronized void setTimestamp() {
        this._timestamp = System.currentTimeMillis() - LineageCacheEviction.getStartTimestamp();
        if (this._timestamp < 0L) {
            throw new DMLRuntimeException("Execution timestamp shouldn't be -ve. Key: " + this._key);
        }
        this.recomputeScore();
    }

    protected synchronized long getTimestamp() {
        return this._timestamp;
    }

    private void recomputeScore() {
        double w1 = LineageCacheConfig.WEIGHTS[0];
        double w2 = LineageCacheConfig.WEIGHTS[1];
        this.score = w1 * ((double)this._computeTime / (double)this.getSize()) + w2 * (double)this.getTimestamp();
    }
}

