/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.VersionInfo;
import org.apache.sysml.conf.ConfigurationManager;

public abstract class MRConfigurationNames {
    protected static final Log LOG;
    public static final String DFS_REPLICATION = "dfs.replication";
    public static final String IO_FILE_BUFFER_SIZE = "io.file.buffer.size";
    public static final String IO_SERIALIZATIONS = "io.serializations";
    public static final String MR_CHILD_JAVA_OPTS = "mapred.child.java.opts";
    public static final String MR_FRAMEWORK_NAME = "mapreduce.framework.name";
    public static final String MR_JOBTRACKER_STAGING_ROOT_DIR = "mapreduce.jobtracker.staging.root.dir";
    public static final String MR_TASKTRACKER_GROUP = "mapreduce.tasktracker.group";
    public static final String YARN_APP_MR_AM_RESOURCE_MB = "yarn.app.mapreduce.am.resource.mb";
    public static final String DFS_BLOCKSIZE;
    public static final String DFS_PERMISSIONS_ENABLED;
    public static final String FS_DEFAULTFS;
    public static final String MR_CLUSTER_LOCAL_DIR;
    public static final String MR_INPUT_FILEINPUTFORMAT_SPLIT_MAXSIZE;
    public static final String MR_INPUT_MULTIPLEINPUTS_DIR_FORMATS;
    public static final String MR_INPUT_MULTIPLEINPUTS_DIR_MAPPERS;
    public static final String MR_JOB_ID;
    public static final String MR_JOBTRACKER_ADDRESS;
    public static final String MR_JOBTRACKER_SYSTEM_DIR;
    public static final String MR_MAP_INPUT_FILE;
    public static final String MR_MAP_INPUT_LENGTH;
    public static final String MR_MAP_INPUT_START;
    public static final String MR_MAP_JAVA_OPTS;
    public static final String MR_MAP_MAXATTEMPTS;
    public static final String MR_MAP_MEMORY_MB;
    public static final String MR_MAP_OUTPUT_COMPRESS;
    public static final String MR_MAP_OUTPUT_COMPRESS_CODEC;
    public static final String MR_MAP_SORT_SPILL_PERCENT;
    public static final String MR_REDUCE_INPUT_BUFFER_PERCENT;
    public static final String MR_REDUCE_JAVA_OPTS;
    public static final String MR_REDUCE_MEMORY_MB;
    public static final String MR_TASK_ATTEMPT_ID;
    public static final String MR_TASK_ID;
    public static final String MR_TASK_IO_SORT_MB;
    public static final String MR_TASK_TIMEOUT;
    public static final String MR_TASKTRACKER_TASKCONTROLLER;

    static {
        boolean mrv2;
        LOG = LogFactory.getLog(MRConfigurationNames.class.getName());
        String hversion = VersionInfo.getBuildVersion();
        boolean hadoop2 = hversion.startsWith("2");
        LOG.debug("Hadoop build version: " + hversion);
        String mrversion = ConfigurationManager.getCachedJobConf().get(MR_FRAMEWORK_NAME);
        boolean bl = mrv2 = mrversion != null && !mrversion.equals("classic");
        if (hadoop2) {
            LOG.debug("Using hadoop 2.x configuration properties.");
            DFS_BLOCKSIZE = "dfs.blocksize";
            DFS_PERMISSIONS_ENABLED = "dfs.permissions.enabled";
            FS_DEFAULTFS = "fs.defaultFS";
        } else {
            LOG.debug("Using hadoop 1.x configuration properties.");
            DFS_BLOCKSIZE = "dfs.block.size";
            DFS_PERMISSIONS_ENABLED = "dfs.permissions";
            FS_DEFAULTFS = "fs.default.name";
        }
        if (mrv2) {
            MR_CLUSTER_LOCAL_DIR = "mapreduce.cluster.local.dir";
            MR_INPUT_FILEINPUTFORMAT_SPLIT_MAXSIZE = "mapreduce.input.fileinputformat.split.maxsize";
            MR_INPUT_MULTIPLEINPUTS_DIR_FORMATS = "mapreduce.input.multipleinputs.dir.formats";
            MR_INPUT_MULTIPLEINPUTS_DIR_MAPPERS = "mapreduce.input.multipleinputs.dir.mappers";
            MR_JOB_ID = "mapreduce.job.id";
            MR_JOBTRACKER_ADDRESS = "mapreduce.jobtracker.address";
            MR_JOBTRACKER_SYSTEM_DIR = "mapreduce.jobtracker.system.dir";
            MR_MAP_INPUT_FILE = "mapreduce.map.input.file";
            MR_MAP_INPUT_LENGTH = "mapreduce.map.input.length";
            MR_MAP_INPUT_START = "mapreduce.map.input.start";
            MR_MAP_JAVA_OPTS = "mapreduce.map.java.opts";
            MR_MAP_MAXATTEMPTS = "mapreduce.map.maxattempts";
            MR_MAP_MEMORY_MB = "mapreduce.map.memory.mb";
            MR_MAP_OUTPUT_COMPRESS = "mapreduce.map.output.compress";
            MR_MAP_OUTPUT_COMPRESS_CODEC = "mapreduce.map.output.compress.codec";
            MR_MAP_SORT_SPILL_PERCENT = "mapreduce.map.sort.spill.percent";
            MR_REDUCE_INPUT_BUFFER_PERCENT = "mapreduce.reduce.input.buffer.percent";
            MR_REDUCE_JAVA_OPTS = "mapreduce.reduce.java.opts";
            MR_REDUCE_MEMORY_MB = "mapreduce.reduce.memory.mb";
            MR_TASK_ATTEMPT_ID = "mapreduce.task.attempt.id";
            MR_TASK_ID = "mapreduce.task.id";
            MR_TASK_IO_SORT_MB = "mapreduce.task.io.sort.mb";
            MR_TASK_TIMEOUT = "mapreduce.task.timeout";
            MR_TASKTRACKER_TASKCONTROLLER = "mapreduce.tasktracker.taskcontroller";
        } else {
            MR_CLUSTER_LOCAL_DIR = "mapred.local.dir";
            MR_INPUT_FILEINPUTFORMAT_SPLIT_MAXSIZE = "mapred.max.split.size";
            MR_INPUT_MULTIPLEINPUTS_DIR_FORMATS = "mapred.input.dir.formats";
            MR_INPUT_MULTIPLEINPUTS_DIR_MAPPERS = "mapred.input.dir.mappers";
            MR_JOB_ID = "mapred.job.id";
            MR_JOBTRACKER_ADDRESS = "mapred.job.tracker";
            MR_JOBTRACKER_SYSTEM_DIR = "mapred.system.dir";
            MR_MAP_INPUT_FILE = "map.input.file";
            MR_MAP_INPUT_LENGTH = "map.input.length";
            MR_MAP_INPUT_START = "map.input.start";
            MR_MAP_JAVA_OPTS = "mapred.map.child.java.opts";
            MR_MAP_MAXATTEMPTS = "mapred.map.max.attempts";
            MR_MAP_MEMORY_MB = "mapred.job.map.memory.mb";
            MR_MAP_OUTPUT_COMPRESS = "mapred.compress.map.output";
            MR_MAP_OUTPUT_COMPRESS_CODEC = "mapred.map.output.compression.codec";
            MR_MAP_SORT_SPILL_PERCENT = "io.sort.spill.percent";
            MR_REDUCE_INPUT_BUFFER_PERCENT = "mapred.job.reduce.input.buffer.percent";
            MR_REDUCE_JAVA_OPTS = "mapred.reduce.child.java.opts";
            MR_REDUCE_MEMORY_MB = "mapred.job.reduce.memory.mb";
            MR_TASK_ATTEMPT_ID = "mapred.task.id";
            MR_TASK_ID = "mapred.tip.id";
            MR_TASK_IO_SORT_MB = "io.sort.mb";
            MR_TASK_TIMEOUT = "mapred.task.timeout";
            MR_TASKTRACKER_TASKCONTROLLER = "mapred.task.tracker.task-controller";
        }
    }
}

