/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.lops.runtime.RunMRJobs;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.MetaDataNumItemsByEachReducer;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.ProgramConverter;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.Statistics;

public class MRJobInstruction
extends Instruction {
    private JobType jobType;
    private String _randInstructions = "";
    private String _recordReaderInstructions = "";
    private String _mapperInstructions = "";
    private String _shuffleInstructions = "";
    private String _aggInstructions = "";
    private String _otherInstructions = "";
    private String[] inputVars;
    private String[] outputVars;
    private byte[] _resultIndices;
    private int iv_numReducers;
    private int iv_replication;
    private String dimsUnknownFilePrefix;
    private double _mapperMem = -1.0;
    private ArrayList<Integer> MRJobInstructionsLineNumbers;
    private String[] inputs;
    private InputInfo[] inputInfos;
    private long[] rlens;
    private long[] clens;
    private int[] brlens;
    private int[] bclens;
    private String[] outputs;
    private OutputInfo[] outputInfos;
    private boolean[] partitioned;
    private ParForProgramBlock.PDataPartitionFormat[] pformats;
    private int[] psizes;
    private MatrixObject[] inputMatrices;
    private MatrixObject[] outputMatrices;
    private Expression.DataType[] inputDataTypes;

    public MRJobInstruction(JobType type) {
        this.jobType = type;
        this.instOpcode = "MR-Job_" + (Object)((Object)this.getJobType());
    }

    public MRJobInstruction(MRJobInstruction that) throws IllegalArgumentException, IllegalAccessException {
        this(that.jobType);
        this._randInstructions = that._randInstructions;
        this._recordReaderInstructions = that._recordReaderInstructions;
        this._mapperInstructions = that._mapperInstructions;
        this._shuffleInstructions = that._shuffleInstructions;
        this._aggInstructions = that._aggInstructions;
        this._otherInstructions = that._otherInstructions;
        this.iv_numReducers = that.iv_numReducers;
        this.iv_replication = that.iv_replication;
        this.dimsUnknownFilePrefix = that.dimsUnknownFilePrefix;
        this._mapperMem = that._mapperMem;
        this.MRJobInstructionsLineNumbers = that.MRJobInstructionsLineNumbers;
        this.inputVars = (String[])that.inputVars.clone();
        this.outputVars = (String[])that.outputVars.clone();
        this._resultIndices = (byte[])that._resultIndices.clone();
        this.inputs = that.inputs;
        this.inputInfos = that.inputInfos;
        this.rlens = that.rlens;
        this.clens = that.clens;
        this.brlens = that.brlens;
        this.bclens = that.bclens;
        this.outputs = that.outputs;
        this.outputInfos = that.outputInfos;
        this.partitioned = that.partitioned;
        this.pformats = that.pformats;
        this.psizes = that.psizes;
        this.inputMatrices = that.inputMatrices;
        this.outputMatrices = that.outputMatrices;
        this.inputDataTypes = that.inputDataTypes;
    }

    @Override
    public Instruction.IType getType() {
        return Instruction.IType.MAPREDUCE_JOB;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public String getIv_instructionsInMapper() {
        return this._mapperInstructions;
    }

    public void setIv_instructionsInMapper(String inst) {
        this._mapperInstructions = inst;
    }

    public String getIv_recordReaderInstructions() {
        return this._recordReaderInstructions;
    }

    public void setIv_recordReaderInstructions(String inst) {
        this._recordReaderInstructions = inst;
    }

    public String getIv_randInstructions() {
        return this._randInstructions;
    }

    public void setIv_randInstructions(String inst) {
        this._randInstructions = inst;
    }

    public String getIv_shuffleInstructions() {
        return this._shuffleInstructions;
    }

    public void setIv_shuffleInstructions(String inst) {
        this._shuffleInstructions = inst;
    }

    public String getIv_aggInstructions() {
        return this._aggInstructions;
    }

    public void setIv_aggInstructions(String inst) {
        this._aggInstructions = inst;
    }

    public String getIv_otherInstructions() {
        return this._otherInstructions;
    }

    public void setIv_otherInstructions(String inst) {
        this._otherInstructions = inst;
    }

    public byte[] getIv_resultIndices() {
        return this._resultIndices;
    }

    public int getIv_numReducers() {
        return this.iv_numReducers;
    }

    public int getIv_replication() {
        return this.iv_replication;
    }

    public double getMemoryRequirements() {
        return this._mapperMem;
    }

    public void setMemoryRequirements(double mem) {
        this._mapperMem = mem;
    }

    public String getDimsUnknownFilePrefix() {
        return this.dimsUnknownFilePrefix;
    }

    public void setDimsUnknownFilePrefix(String prefix) {
        this.dimsUnknownFilePrefix = prefix;
    }

    public String[] getInputVars() {
        return this.inputVars;
    }

    public String[] getOutputVars() {
        return this.outputVars;
    }

    public ArrayList<Integer> getMRJobInstructionsLineNumbers() {
        return this.MRJobInstructionsLineNumbers;
    }

    public void setOutputs(byte[] outputIndices) {
        this._resultIndices = outputIndices;
    }

    public void setNumberOfReducers(int numReducers) {
        this.iv_numReducers = numReducers;
    }

    public void setReplication(int replication) {
        this.iv_replication = replication;
    }

    public void setInputOutputLabels(String[] inputLabels, String[] outputLabels) {
        this.inputVars = inputLabels;
        this.outputVars = outputLabels;
    }

    public void setRecordReaderInstructions(String rrInstructions) {
        this._recordReaderInstructions = rrInstructions;
    }

    public void setMapperInstructions(String mapperInstructions) {
        this._mapperInstructions = mapperInstructions;
    }

    public void setShuffleInstructions(String shuffleInstructions) {
        this._shuffleInstructions = shuffleInstructions;
    }

    public void setAggregateInstructionsInReducer(String aggInstructions) {
        this._aggInstructions = aggInstructions;
    }

    public void setOtherInstructionsInReducer(String otherInstructions) {
        this._otherInstructions = otherInstructions;
    }

    public void setRandInstructions(String randInstructions) {
        this._randInstructions = randInstructions;
    }

    public void setMRJobInstructionsLineNumbers(ArrayList<Integer> MRJobLineNumbers) {
        this.MRJobInstructionsLineNumbers = MRJobLineNumbers;
    }

    public void setGMRInstructions(String[] inLabels, String recordReaderInstructions, String mapperInstructions, String aggInstructions, String otherInstructions, String[] outLabels, byte[] resultIndex, int numReducers, int replication) {
        this.setOutputs(resultIndex);
        this.setRecordReaderInstructions(recordReaderInstructions);
        this.setMapperInstructions(mapperInstructions);
        this.setShuffleInstructions("");
        this.setAggregateInstructionsInReducer(aggInstructions);
        this.setOtherInstructionsInReducer(otherInstructions);
        this.setInputOutputLabels(inLabels, outLabels);
        this.setNumberOfReducers(numReducers);
        this.setReplication(replication);
    }

    public void setReBlockInstructions(String[] inLabels, String mapperInstructions, String reblockInstructions, String otherInstructions, String[] outLabels, byte[] resultIndex, int numReducers, int replication) {
        this.setOutputs(resultIndex);
        this.setMapperInstructions(mapperInstructions);
        this.setShuffleInstructions(reblockInstructions);
        this.setAggregateInstructionsInReducer("");
        this.setOtherInstructionsInReducer(otherInstructions);
        this.setInputOutputLabels(inLabels, outLabels);
        this.setNumberOfReducers(numReducers);
        this.setReplication(replication);
    }

    public boolean findMRInstructions(int lineNum) {
        if (!DMLScript.ENABLE_DEBUG_MODE) {
            System.err.println("Error: Expecting debug mode to be enabled for this functionality");
            return false;
        }
        for (Integer lineNumber : this.MRJobInstructionsLineNumbers) {
            if (lineNum != lineNumber) continue;
            return true;
        }
        return false;
    }

    public String getString(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(",");
            sb.append(Byte.toString(arr[i]));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        String instruction = "";
        instruction = instruction + "jobtype = " + (Object)((Object)this.jobType) + " \n";
        instruction = instruction + "input labels = " + Arrays.toString(this.inputVars) + " \n";
        instruction = instruction + "recReader inst = " + this._recordReaderInstructions + " \n";
        instruction = instruction + "rand inst = " + this._randInstructions + " \n";
        instruction = instruction + "mapper inst = " + this._mapperInstructions + " \n";
        instruction = instruction + "shuffle inst = " + this._shuffleInstructions + " \n";
        instruction = instruction + "agg inst = " + this._aggInstructions + " \n";
        instruction = instruction + "other inst = " + this._otherInstructions + " \n";
        instruction = instruction + "output labels = " + Arrays.toString(this.outputVars) + " \n";
        instruction = instruction + "result indices = " + this.getString(this._resultIndices) + " \n";
        instruction = instruction + "num reducers = " + this.iv_numReducers + " \n";
        instruction = instruction + "replication = " + this.iv_replication + " \n";
        return instruction;
    }

    public String getMRString(boolean debug) {
        String[] instStr;
        int i;
        String[] instArray;
        if (!DMLScript.ENABLE_DEBUG_MODE) {
            System.err.println("Error: Expecting debug mode to be enabled for this functionality");
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MR-Job[\n");
        sb.append("\t\t\t\tjobtype        = " + (Object)((Object)this.jobType) + " \n");
        if (!debug) {
            sb.append("\t\t\t\tinput labels   = ");
            sb.append(Arrays.toString(this.inputVars));
            sb.append(" \n");
        }
        if (this._recordReaderInstructions.length() > 0) {
            instArray = this._recordReaderInstructions.split("\u2021");
            if (!debug) {
                sb.append("\t\t\t\trecReader inst = ");
                sb.append(instArray[0]);
                sb.append(" \n");
            } else {
                String[] instStr2 = MRJobInstruction.prepareInstruction(instArray[0]).split(" ");
                sb.append("\t\t\t\trecReader inst = ");
                sb.append(instStr2[0]);
                sb.append(" ");
                sb.append(instStr2[1]);
                sb.append(" \n");
            }
            for (i = 1; i < instArray.length; ++i) {
                if (!debug) {
                    sb.append("\t\t\t\t                 ");
                    sb.append(instArray[i]);
                    sb.append(" \n");
                    continue;
                }
                instStr = MRJobInstruction.prepareInstruction(instArray[i]).split(" ");
                sb.append("\t\t\t\t                 ");
                sb.append(instStr[0]);
                sb.append(" ");
                sb.append(instStr[1]);
                sb.append(" \n");
            }
        }
        if (this._randInstructions.length() > 0) {
            instArray = this._randInstructions.split("\u2021");
            if (!debug) {
                sb.append("\t\t\t\trand inst      = ");
                sb.append(instArray[0]);
                sb.append(" \n");
            } else {
                String[] instStr3 = MRJobInstruction.prepareInstruction(instArray[0]).split(" ");
                sb.append("\t\t\t\trand inst      = ");
                sb.append(instStr3[0]);
                sb.append(" ");
                sb.append(instStr3[1]);
                sb.append(" \n");
            }
            for (i = 1; i < instArray.length; ++i) {
                if (!debug) {
                    sb.append("\t\t\t\t                 ");
                    sb.append(instArray[i]);
                    sb.append(" \n");
                    continue;
                }
                instStr = MRJobInstruction.prepareInstruction(instArray[i]).split(" ");
                sb.append("\t\t\t\t                 ");
                sb.append(instStr[0]);
                sb.append(" ");
                sb.append(instStr[1]);
                sb.append(" \n");
            }
        }
        if (this._mapperInstructions.length() > 0) {
            instArray = this._mapperInstructions.split("\u2021");
            if (!debug) {
                sb.append("\t\t\t\tmapper inst    = ");
                sb.append(instArray[0]);
                sb.append(" \n");
            } else {
                String[] instStr4 = MRJobInstruction.prepareInstruction(instArray[0]).split(" ");
                sb.append("\t\t\t\tmapper inst    = ");
                sb.append(instStr4[0]);
                sb.append(" ");
                sb.append(instStr4[1]);
                sb.append(" \n");
            }
            for (i = 1; i < instArray.length; ++i) {
                if (!debug) {
                    sb.append("\t\t\t\t                 ");
                    sb.append(instArray[i]);
                    sb.append(" \n");
                    continue;
                }
                instStr = MRJobInstruction.prepareInstruction(instArray[i]).split(" ");
                sb.append("\t\t\t\t                 ");
                sb.append(instStr[0]);
                sb.append(" ");
                sb.append(instStr[1]);
                sb.append(" \n");
            }
        }
        if (this._shuffleInstructions.length() > 0) {
            instArray = this._shuffleInstructions.split("\u2021");
            if (!debug) {
                sb.append("\t\t\t\tshuffle inst   = ");
                sb.append(instArray[0]);
                sb.append(" \n");
            } else {
                String[] instStr5 = MRJobInstruction.prepareInstruction(instArray[0]).split(" ");
                sb.append("\t\t\t\tshuffle inst   = ");
                sb.append(instStr5[0]);
                sb.append(" ");
                sb.append(instStr5[1]);
                sb.append(" \n");
            }
            for (i = 1; i < instArray.length; ++i) {
                if (!debug) {
                    sb.append("\t\t\t\t                 ");
                    sb.append(instArray[i]);
                    sb.append(" \n");
                    continue;
                }
                instStr = MRJobInstruction.prepareInstruction(instArray[i]).split(" ");
                sb.append("\t\t\t\t                 ");
                sb.append(instStr[0]);
                sb.append(" ");
                sb.append(instStr[1]);
                sb.append(" \n");
            }
        }
        if (this._aggInstructions.length() > 0) {
            instArray = this._aggInstructions.split("\u2021");
            if (!debug) {
                sb.append("\t\t\t\tagg inst       = ");
                sb.append(instArray[0]);
                sb.append(" \n");
            } else {
                String[] instStr6 = MRJobInstruction.prepareInstruction(instArray[0]).split(" ");
                sb.append("\t\t\t\tagg inst       = ");
                sb.append(instStr6[0]);
                sb.append(" ");
                sb.append(instStr6[1]);
                sb.append(" \n");
            }
            for (i = 1; i < instArray.length; ++i) {
                if (!debug) {
                    sb.append("\t\t\t\t                 ");
                    sb.append(instArray[i]);
                    sb.append(" \n");
                    continue;
                }
                instStr = MRJobInstruction.prepareInstruction(instArray[i]).split(" ");
                sb.append("\t\t\t\t                 ");
                sb.append(instStr[0]);
                sb.append(" ");
                sb.append(instStr[1]);
                sb.append(" \n");
            }
        }
        if (this._otherInstructions.length() > 0) {
            instArray = this._otherInstructions.split("\u2021");
            if (!debug) {
                sb.append("\t\t\t\tother inst     = ");
                sb.append(instArray[0]);
                sb.append(" \n");
            } else {
                String[] instStr7 = MRJobInstruction.prepareInstruction(instArray[0]).split(" ");
                sb.append("\t\t\t\tother inst     = ");
                sb.append(instStr7[0]);
                sb.append(" ");
                sb.append(instStr7[1]);
                sb.append(" \n");
            }
            for (int i2 = 1; i2 < instArray.length; ++i2) {
                if (!debug) {
                    sb.append("\t\t\t\t                 ");
                    sb.append(instArray[i2]);
                    sb.append(" \n");
                    continue;
                }
                instStr = MRJobInstruction.prepareInstruction(instArray[i2]).split(" ");
                sb.append("\t\t\t\t                 ");
                sb.append(instStr[0]);
                sb.append(" ");
                sb.append(instStr[1]);
                sb.append(" \n");
            }
        }
        if (!debug) {
            sb.append("\t\t\t\toutput labels  = ");
            sb.append(Arrays.toString(this.outputVars));
            sb.append(" \n");
        }
        sb.append("\t\t\t        ]");
        return sb.toString();
    }

    @Override
    public void printMe() {
        LOG.debug("\nMRInstructions: \n" + this.toString());
    }

    private static String getOps(String inst) {
        StringBuilder sb = new StringBuilder();
        for (String i : inst.split("\u2021")) {
            sb.append(",");
            sb.append(i.split("\u00b0")[0]);
        }
        return sb.toString();
    }

    @Override
    public String getGraphString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.jobType);
        if (!this._mapperInstructions.equals("")) {
            sb.append(",map(");
            sb.append(MRJobInstruction.getOps(this._mapperInstructions));
            sb.append(")");
        }
        if (!this._shuffleInstructions.equals("")) {
            sb.append(",shuffle(");
            sb.append(MRJobInstruction.getOps(this._shuffleInstructions));
            sb.append(")");
        }
        if (!this._aggInstructions.equals("")) {
            sb.append(",agg(");
            sb.append(MRJobInstruction.getOps(this._aggInstructions));
            sb.append(")");
        }
        if (!this._otherInstructions.equals("")) {
            sb.append(",other(");
            sb.append(MRJobInstruction.getOps(this._otherInstructions));
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isMapOnly() {
        return !(this._shuffleInstructions != null && this._shuffleInstructions.trim().length() != 0 || this._aggInstructions != null && this._aggInstructions.trim().length() != 0 || this._otherInstructions != null && this._otherInstructions.trim().length() != 0);
    }

    public String[] getInputs() {
        return this.inputs;
    }

    public InputInfo[] getInputInfos() {
        return this.inputInfos;
    }

    public long[] getRlens() {
        return this.rlens;
    }

    public long[] getClens() {
        return this.clens;
    }

    public int[] getBrlens() {
        return this.brlens;
    }

    public int[] getBclens() {
        return this.bclens;
    }

    public String[] getOutputs() {
        return this.outputs;
    }

    public OutputInfo[] getOutputInfos() {
        return this.outputInfos;
    }

    public MatrixObject[] getInputMatrices() {
        return this.inputMatrices;
    }

    public boolean[] getPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean[] partitioned) {
        this.partitioned = partitioned;
    }

    public ParForProgramBlock.PDataPartitionFormat[] getPformats() {
        return this.pformats;
    }

    public void setPformats(ParForProgramBlock.PDataPartitionFormat[] pformats) {
        this.pformats = pformats;
    }

    public int[] getPsizes() {
        return this.psizes;
    }

    public void setPsizes(int[] psizes) {
        this.psizes = psizes;
    }

    public MatrixObject[] extractInputMatrices(ExecutionContext ec) {
        ArrayList<MatrixObject> inputmat = new ArrayList<MatrixObject>();
        this.inputDataTypes = new Expression.DataType[this.inputVars.length];
        for (int i = 0; i < this.inputVars.length; ++i) {
            Data d = ec.getVariable(this.inputVars[i]);
            this.inputDataTypes[i] = d.getDataType();
            if (d.getDataType() == Expression.DataType.MATRIX) {
                inputmat.add((MatrixObject)d);
                continue;
            }
            if (d.getDataType() != Expression.DataType.FRAME) continue;
            FrameObject fo = (FrameObject)d;
            MatrixObject mo = new MatrixObject(fo.getValueType(), fo.getFileName(), fo.getMetaData());
            mo.setFileFormatProperties(fo.getFileFormatProperties());
            inputmat.add(mo);
        }
        this.inputMatrices = inputmat.toArray(new MatrixObject[inputmat.size()]);
        this.populateInputs();
        return this.inputMatrices;
    }

    public MatrixObject[] getOutputMatrices() {
        return this.outputMatrices;
    }

    public MatrixObject[] extractOutputMatrices(ExecutionContext ec) {
        this.outputMatrices = new MatrixObject[this.getOutputVars().length];
        int ind = 0;
        for (String oo : this.getOutputVars()) {
            Data d = ec.getVariable(oo);
            if (d.getDataType() != Expression.DataType.MATRIX) {
                throw new DMLRuntimeException((Object)((Object)this.getJobType()) + ": invalid datatype (" + (Object)((Object)d.getDataType()) + ") for output variable " + oo);
            }
            this.outputMatrices[ind++] = (MatrixObject)d;
        }
        this.populateOutputs();
        return this.outputMatrices;
    }

    private void populateInputs() {
        this.inputs = new String[this.inputMatrices.length];
        this.inputInfos = new InputInfo[this.inputMatrices.length];
        this.rlens = new long[this.inputMatrices.length];
        this.clens = new long[this.inputMatrices.length];
        this.brlens = new int[this.inputMatrices.length];
        this.bclens = new int[this.inputMatrices.length];
        this.partitioned = new boolean[this.inputMatrices.length];
        this.pformats = new ParForProgramBlock.PDataPartitionFormat[this.inputMatrices.length];
        this.psizes = new int[this.inputMatrices.length];
        for (int i = 0; i < this.inputMatrices.length; ++i) {
            this.inputs[i] = this.inputMatrices[i].getFileName();
            MatrixCharacteristics mc = this.inputMatrices[i].getMatrixCharacteristics();
            this.rlens[i] = mc.getRows();
            this.clens[i] = mc.getCols();
            this.brlens[i] = mc.getRowsPerBlock();
            this.bclens[i] = mc.getColsPerBlock();
            if (this.inputMatrices[i].getMetaData() instanceof MetaDataFormat) {
                this.inputInfos[i] = ((MetaDataFormat)this.inputMatrices[i].getMetaData()).getInputInfo();
            } else if (this.inputMatrices[i].getMetaData() instanceof MetaDataNumItemsByEachReducer) {
                this.inputInfos[i] = InputInfo.InputInfoForSortOutput;
                this.inputInfos[i].metadata = this.inputMatrices[i].getMetaData();
            }
            this.partitioned[i] = this.inputMatrices[i].isPartitioned();
            this.pformats[i] = this.inputMatrices[i].getPartitionFormat();
            this.psizes[i] = this.inputMatrices[i].getPartitionSize();
        }
    }

    private void populateOutputs() {
        this.outputs = new String[this.outputVars.length];
        this.outputInfos = new OutputInfo[this.outputVars.length];
        for (int i = 0; i < this.outputVars.length; ++i) {
            this.outputs[i] = this.outputMatrices[i].getFileName();
            MetaDataFormat md = (MetaDataFormat)this.outputMatrices[i].getMetaData();
            this.outputInfos[i] = md.getOutputInfo();
        }
    }

    private static String prepareInstruction(String inst) {
        String tmp = inst;
        tmp = tmp.replaceAll("\u00b0", " ");
        tmp = tmp.replaceAll("\u00b7", ".");
        tmp = tmp.replaceAll("\u2021", ", ");
        return tmp;
    }

    public void printCompleteMRJobInstruction(MatrixCharacteristics[] resultStats) {
        int i;
        LOG.trace("jobtype" + (Object)((Object)this.jobType));
        LOG.trace("Inputs: \n");
        int mi = 0;
        for (i = 0; i < this.inputVars.length; ++i) {
            if (this.inputDataTypes[i] == Expression.DataType.SCALAR) {
                LOG.trace("    " + this.inputVars[i] + " - SCALAR input (replaced w/ value)");
                continue;
            }
            if (this.inputDataTypes[i] == Expression.DataType.MATRIX) {
                LOG.trace("    " + this.inputVars[i] + " - [" + this.inputs[mi] + "]  [" + this.rlens[mi] + ", " + this.clens[mi] + "]  nnz[" + this.inputMatrices[mi].getNnz() + "]  block[" + this.brlens[mi] + ", " + this.bclens[mi] + "]  [" + InputInfo.inputInfoToString(this.inputInfos[mi]) + "]");
                ++mi;
                continue;
            }
            LOG.trace("    " + this.inputVars[i] + " - " + (Object)((Object)this.inputDataTypes[i]));
        }
        LOG.trace("  Instructions:");
        if (!this._recordReaderInstructions.equals("")) {
            LOG.trace("    recReader inst - " + this._recordReaderInstructions);
        }
        if (!this._randInstructions.equals("")) {
            LOG.trace("    rand inst - " + this._randInstructions);
        }
        if (!this._mapperInstructions.equals("")) {
            LOG.trace("    mapper inst - " + this._mapperInstructions);
        }
        if (!this._shuffleInstructions.equals("")) {
            LOG.trace("    shuffle inst - " + this._shuffleInstructions);
        }
        if (!this._aggInstructions.equals("")) {
            LOG.trace("    agg inst - " + this._aggInstructions);
        }
        if (!this._otherInstructions.equals("")) {
            LOG.trace("    other inst - " + this._otherInstructions);
        }
        LOG.trace("  Outputs:");
        for (i = 0; i < this.outputVars.length; ++i) {
            LOG.trace("    " + this._resultIndices[i] + " : " + this.outputVars[i] + " - [" + this.outputs[i] + "]  [" + resultStats[i].getRows() + ", " + resultStats[i].getCols() + "]  nnz[" + this.outputMatrices[i].getNnz() + "]  block[" + resultStats[i].getRows() + ", " + resultStats[i].getColsPerBlock() + "]  [" + OutputInfo.outputInfoToString(this.outputInfos[i]) + "]");
        }
        LOG.trace("  #Reducers - " + this.iv_numReducers);
        LOG.trace("  Replication - " + this.iv_replication);
    }

    @Override
    public void updateInstructionThreadID(String pattern, String replace) {
        if (this.dimsUnknownFilePrefix != null) {
            this.dimsUnknownFilePrefix = this.dimsUnknownFilePrefix.replaceAll(pattern, replace);
        }
        if (this.getJobType() == JobType.DATAGEN) {
            String rndinst = this.getIv_randInstructions().trim();
            StringBuilder rndinst2 = new StringBuilder();
            if (rndinst != null && rndinst.length() > 0) {
                String[] instSet;
                for (String dginst : instSet = rndinst.split("\u2021")) {
                    String[] parts;
                    if (rndinst2.length() > 0) {
                        rndinst2.append("\u2021");
                    }
                    if ((parts = dginst.split("\u00b0")) == null || parts.length < 2) {
                        throw new DMLRuntimeException("Invalid datagen instruction: " + dginst);
                    }
                    int pos = -1;
                    if (parts[1].equals("rand")) {
                        pos = 13;
                    }
                    if (parts[1].equals("seq")) {
                        pos = 11;
                    }
                    if (pos > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < parts.length; ++i) {
                            if (i > 0) {
                                sb.append("\u00b0");
                            }
                            if (i == pos) {
                                sb.append(ProgramConverter.saveReplaceFilenameThreadID(parts[i], pattern, replace));
                                continue;
                            }
                            sb.append(parts[i]);
                        }
                        rndinst2.append(sb.toString());
                        continue;
                    }
                    rndinst2.append(dginst);
                }
                this.setRandInstructions(rndinst2.toString());
            }
        }
    }

    public boolean isMergableMRJobInstruction(MRJobInstruction that) {
        byte maxIx2;
        byte maxIx1;
        boolean blockedThat;
        boolean blockedThis;
        boolean ret = true;
        if (this.jobType != that.jobType) {
            ret = false;
        }
        if ((blockedThis = MRJobConfiguration.deriveRepresentation(this.inputInfos)) != (blockedThat = MRJobConfiguration.deriveRepresentation(that.inputInfos))) {
            ret = false;
        }
        if (this._mapperMem + that._mapperMem > OptimizerUtils.getRemoteMemBudgetMap(true)) {
            ret = false;
        }
        if ((maxIx1 = UtilFunctions.max(this._resultIndices)) + (maxIx2 = UtilFunctions.max(that._resultIndices)) > 127) {
            ret = false;
        }
        if (this.isMapOnly() != that.isMapOnly()) {
            ret = false;
        }
        return ret;
    }

    public void mergeMRJobInstruction(MRJobInstruction that) {
        int i;
        int i2;
        int i3;
        int i4;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Current instruction:\n" + this.toString());
            LOG.debug("Next instruction:\n" + that.toString());
        }
        byte maxIxInst1 = UtilFunctions.max(this._resultIndices);
        byte maxIxInst2 = UtilFunctions.max(that._resultIndices);
        int sharedIx = 0;
        HashMap<String, Byte> inMap = new HashMap<String, Byte>();
        for (i4 = 0; i4 < this.inputs.length; ++i4) {
            inMap.put(this.inputs[i4], (byte)i4);
        }
        for (i4 = 0; i4 < that.inputs.length; ++i4) {
            if (!inMap.containsKey(that.inputs[i4])) continue;
            sharedIx = (byte)(sharedIx + 1);
        }
        byte lenInputs = (byte)(this.inputs.length + that.inputs.length - sharedIx);
        HashMap<Byte, Byte> transMap1 = new HashMap<Byte, Byte>();
        for (i3 = 0; i3 < this.inputs.length; ++i3) {
            transMap1.put((byte)i3, (byte)i3);
        }
        for (i3 = this.inputs.length; i3 <= maxIxInst1; ++i3) {
            transMap1.put((byte)i3, (byte)(that.inputs.length - sharedIx + i3));
        }
        HashMap<Byte, Byte> transMap2 = new HashMap<Byte, Byte>();
        byte nextIX = (byte)this.inputs.length;
        for (i2 = 0; i2 < that.inputs.length; ++i2) {
            if (!inMap.containsKey(that.inputs[i2])) {
                byte by = nextIX;
                nextIX = (byte)(nextIX + 1);
                inMap.put(that.inputs[i2], by);
            }
            transMap2.put((byte)i2, (Byte)inMap.get(that.inputs[i2]));
        }
        nextIX = (byte)(lenInputs + (maxIxInst1 + 1 - this.inputs.length));
        for (i2 = that.inputs.length; i2 <= maxIxInst2; ++i2) {
            byte by = nextIX;
            nextIX = (byte)(nextIX + 1);
            transMap2.put((byte)i2, by);
        }
        byte llen = lenInputs;
        int len = this.inputs.length;
        int olen = this.outputs.length + that.outputs.length;
        String[] linputs = new String[llen];
        InputInfo[] linputInfos = new InputInfo[llen];
        MatrixObject[] linputMatrices = new MatrixObject[llen];
        ParForProgramBlock.PDataPartitionFormat[] lpformats = new ParForProgramBlock.PDataPartitionFormat[llen];
        long[] lrlens = new long[llen];
        long[] lclens = new long[llen];
        int[] lbrlens = new int[llen];
        int[] lbclens = new int[llen];
        String[] loutputs = new String[olen];
        OutputInfo[] loutputInfos = new OutputInfo[olen];
        MatrixObject[] loutputMatrices = new MatrixObject[olen];
        byte[] lresultIndexes = new byte[olen];
        System.arraycopy(this.inputs, 0, linputs, 0, len);
        System.arraycopy(this.inputInfos, 0, linputInfos, 0, len);
        System.arraycopy(this.inputMatrices, 0, linputMatrices, 0, len);
        System.arraycopy(this.pformats, 0, lpformats, 0, len);
        System.arraycopy(this.rlens, 0, lrlens, 0, len);
        System.arraycopy(this.clens, 0, lclens, 0, len);
        System.arraycopy(this.brlens, 0, lbrlens, 0, len);
        System.arraycopy(this.bclens, 0, lbclens, 0, len);
        System.arraycopy(this.outputs, 0, loutputs, 0, this.outputs.length);
        System.arraycopy(this.outputInfos, 0, loutputInfos, 0, this.outputs.length);
        System.arraycopy(this.outputMatrices, 0, loutputMatrices, 0, this.outputs.length);
        for (i = 0; i < that.inputs.length; ++i) {
            byte ixSrc = (byte)i;
            byte ixTgt = (Byte)transMap2.get((byte)i);
            linputs[ixTgt] = that.inputs[ixSrc];
            linputInfos[ixTgt] = that.inputInfos[ixSrc];
            linputMatrices[ixTgt] = that.inputMatrices[ixSrc];
            lpformats[ixTgt] = that.pformats[ixSrc];
            lrlens[ixTgt] = that.rlens[ixSrc];
            lclens[ixTgt] = that.clens[ixSrc];
            lbrlens[ixTgt] = that.brlens[ixSrc];
            lbclens[ixTgt] = that.bclens[ixSrc];
        }
        for (i = 0; i < this._resultIndices.length; ++i) {
            lresultIndexes[i] = (Byte)transMap1.get(this._resultIndices[i]);
        }
        for (i = 0; i < that._resultIndices.length; ++i) {
            loutputs[this._resultIndices.length + i] = that.outputs[i];
            loutputInfos[this._resultIndices.length + i] = that.outputInfos[i];
            loutputMatrices[this._resultIndices.length + i] = that.outputMatrices[i];
            lresultIndexes[this._resultIndices.length + i] = transMap2.get(that._resultIndices[i]);
        }
        this.inputs = linputs;
        this.inputInfos = linputInfos;
        this.inputMatrices = linputMatrices;
        this.pformats = lpformats;
        this.outputs = loutputs;
        this.outputInfos = loutputInfos;
        this.outputMatrices = loutputMatrices;
        this.rlens = lrlens;
        this.clens = lclens;
        this.brlens = lbrlens;
        this.bclens = lbclens;
        this._resultIndices = lresultIndexes;
        String randInst1 = MRJobInstruction.replaceInstructionStringWithTransMap(this.getIv_randInstructions(), transMap1);
        String randInst2 = MRJobInstruction.replaceInstructionStringWithTransMap(that.getIv_randInstructions(), transMap2);
        String rrInst1 = MRJobInstruction.replaceInstructionStringWithTransMap(this.getIv_recordReaderInstructions(), transMap1);
        String rrInst2 = MRJobInstruction.replaceInstructionStringWithTransMap(that.getIv_recordReaderInstructions(), transMap2);
        String mapInst1 = MRJobInstruction.replaceInstructionStringWithTransMap(this.getIv_instructionsInMapper(), transMap1);
        String mapInst2 = MRJobInstruction.replaceInstructionStringWithTransMap(that.getIv_instructionsInMapper(), transMap2);
        String shuffleInst1 = MRJobInstruction.replaceInstructionStringWithTransMap(this.getIv_shuffleInstructions(), transMap1);
        String shuffleInst2 = MRJobInstruction.replaceInstructionStringWithTransMap(that.getIv_shuffleInstructions(), transMap2);
        String aggInst1 = MRJobInstruction.replaceInstructionStringWithTransMap(this.getIv_aggInstructions(), transMap1);
        String aggInst2 = MRJobInstruction.replaceInstructionStringWithTransMap(that.getIv_aggInstructions(), transMap2);
        String otherInst1 = MRJobInstruction.replaceInstructionStringWithTransMap(this.getIv_otherInstructions(), transMap1);
        String otherInst2 = MRJobInstruction.replaceInstructionStringWithTransMap(that.getIv_otherInstructions(), transMap2);
        this.setIv_randInstructions(MRJobInstruction.concatenateInstructions(randInst1, randInst2));
        this.setIv_recordReaderInstructions(MRJobInstruction.concatenateInstructions(rrInst1, rrInst2));
        this.setIv_instructionsInMapper(MRJobInstruction.concatenateInstructions(mapInst1, mapInst2));
        this.setIv_shuffleInstructions(MRJobInstruction.concatenateInstructions(shuffleInst1, shuffleInst2));
        this.setIv_aggInstructions(MRJobInstruction.concatenateInstructions(aggInst1, aggInst2));
        this.setIv_otherInstructions(MRJobInstruction.concatenateInstructions(otherInst1, otherInst2));
        this._mapperMem += that._mapperMem;
        LOG.debug("Merged instruction:\n" + this.toString());
    }

    private static String replaceInstructionStringWithTransMap(String inst, HashMap<Byte, Byte> transMap) {
        if (inst == null || inst.isEmpty() || transMap.isEmpty()) {
            return inst;
        }
        String[] pinst = inst.split("\u2021");
        StringBuilder instOut = new StringBuilder();
        for (String lpinst : pinst) {
            String[] parts = InstructionUtils.getInstructionPartsWithValueType(lpinst);
            for (int i = 0; i < parts.length; ++i) {
                String lpart = parts[i];
                int pos = lpart.indexOf("\u00b7" + Expression.DataType.MATRIX.toString());
                if (pos <= 0) continue;
                String index = lpart.substring(0, pos);
                String newindex = String.valueOf(transMap.get(Byte.parseByte(index)));
                parts[i] = newindex + lpart.substring(pos);
            }
            if (instOut.length() > 0) {
                instOut.append("\u2021");
            }
            instOut.append("MR");
            for (String lpart : parts) {
                instOut.append("\u00b0");
                instOut.append(lpart);
            }
        }
        return instOut.toString();
    }

    private static String concatenateInstructions(String inst1, String inst2) {
        boolean emptyInst1 = inst1 == null || inst1.length() == 0;
        boolean emptyInst2 = inst2 == null || inst2.length() == 0;
        String ret = "";
        if (!emptyInst1 && !emptyInst2) {
            ret = inst1 + "\u2021" + inst2;
        } else if (!emptyInst1) {
            ret = inst1;
        } else if (!emptyInst2) {
            ret = inst2;
        }
        return ret;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE) {
            throw new DMLRuntimeException("MapReduce jobs cannot be executed when execution mode = singlenode");
        }
        JobReturn jb = RunMRJobs.prepareAndSubmitJob(this, ec);
        if (this.getJobType() == JobType.SORT && jb.getMetaData().length > 0) {
            for (int index = 0; index < jb.getMetaData().length; ++index) {
                String varname = this.getOutputVars()[index];
                ec.setMetaData(varname, jb.getMetaData()[index]);
            }
        } else if (jb.getMetaData().length > 0) {
            for (int index = 0; index < jb.getMetaData().length; ++index) {
                String varname = this.getOutputVars()[index];
                MatrixCharacteristics mc = jb.getMetaData(index).getMatrixCharacteristics();
                ec.getVariable(varname).updateMatrixCharacteristics(mc);
            }
        }
        Statistics.incrementNoOfExecutedMRJobs();
    }
}

