/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class PMMJ
extends Lop {
    public static final String OPCODE = "pmm";
    private CacheType _cacheType = null;
    private boolean _outputEmptyBlocks = true;
    private int _numThreads = 1;

    public PMMJ(Lop pminput, Lop rightinput, Lop nrow, Expression.DataType dt, Expression.ValueType vt, boolean partitioned, boolean emptyBlocks, LopProperties.ExecType et) {
        super(Lop.Type.PMMJ, dt, vt);
        this.addInput(pminput);
        this.addInput(rightinput);
        this.addInput(nrow);
        pminput.addOutput(this);
        rightinput.addOutput(this);
        nrow.addOutput(this);
        this._cacheType = partitioned ? CacheType.LEFT_PART : CacheType.LEFT;
        this._outputEmptyBlocks = emptyBlocks;
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        LopProperties.ExecLocation el = et == LopProperties.ExecType.MR ? LopProperties.ExecLocation.Map : LopProperties.ExecLocation.ControlProgram;
        this.lps.addCompatibility(JobType.GMR);
        this.lps.addCompatibility(JobType.DATAGEN);
        this.lps.setProperties(this.inputs, et, el, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation = PMMJ";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(input_index3), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input_index1, String input_index2, String input_index3, String output_index) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input_index2));
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.MR) {
            sb.append(this.getInputs().get(2).prepScalarLabel());
        } else {
            sb.append(this.getInputs().get(2).prepInputOperand(input_index3));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append((Object)this._cacheType);
        } else if (this.getExecType() == LopProperties.ExecType.MR) {
            sb.append("\u00b0");
            sb.append((Object)this._cacheType);
            sb.append("\u00b0");
            sb.append(this._outputEmptyBlocks);
        } else if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return true;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        return new int[]{1};
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public static enum CacheType {
        LEFT,
        LEFT_PART;

    }
}

