/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;
import org.apache.sysml.udf.Scalar;

public class DynamicReadMatrixRcCP
extends PackageFunction {
    private static final long serialVersionUID = 1L;
    private Matrix _ret;
    private Scalar _rc;

    @Override
    public int getNumFunctionOutputs() {
        return 2;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        if (pos == 0) {
            return this._ret;
        }
        if (pos == 1) {
            return this._rc;
        }
        throw new RuntimeException("Invalid function output being requested");
    }

    @Override
    public void execute() {
        try {
            String fname = ((Scalar)this.getFunctionInput(0)).getValue();
            Integer m = Integer.parseInt(((Scalar)this.getFunctionInput(1)).getValue());
            Integer n = Integer.parseInt(((Scalar)this.getFunctionInput(2)).getValue());
            String format = ((Scalar)this.getFunctionInput(3)).getValue();
            InputInfo ii = InputInfo.stringToInputInfo(format);
            OutputInfo oi = OutputInfo.BinaryBlockOutputInfo;
            String fnameTmp = this.createOutputFilePathAndName("TMP");
            this._ret = new Matrix(fnameTmp, m.intValue(), n.intValue(), Matrix.ValueType.Double);
            MatrixBlock mbTmp = DataConverter.readMatrixFromHDFS(fname, ii, m.intValue(), n.intValue(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
            this._ret.setMatrixDoubleArray(mbTmp, oi, ii);
            this._rc = new Scalar(Scalar.ScalarValueType.Integer, "0");
        }
        catch (Exception e) {
            this._rc = new Scalar(Scalar.ScalarValueType.Integer, "1");
        }
    }
}

