/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FrameReader;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.FrameBlock;

public class FrameReaderBinaryBlock
extends FrameReader {
    @Override
    public final FrameBlock readFrameFromHDFS(String fname, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Expression.ValueType[] lschema = FrameReaderBinaryBlock.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderBinaryBlock.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderBinaryBlock.createOutputFrameBlock(lschema, lnames, rlen);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FrameReaderBinaryBlock.checkValidInputFile(fs, path);
        this.readBinaryBlockFrameFromHDFS(path, job, fs, ret, rlen, clen);
        return ret;
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Expression.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        throw new DMLRuntimeException("Not implemented yet.");
    }

    protected void readBinaryBlockFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, long rlen, long clen) throws IOException, DMLRuntimeException {
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
            FrameReaderBinaryBlock.readBinaryBlockFrameFromSequenceFile(lpath, job, fs, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void readBinaryBlockFrameFromSequenceFile(Path path, JobConf job, FileSystem fs, FrameBlock dest) throws IOException, DMLRuntimeException {
        int rlen = dest.getNumRows();
        int clen = dest.getNumColumns();
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, path, (Configuration)job);
        LongWritable key = new LongWritable(-1L);
        FrameBlock value = new FrameBlock();
        try {
            while (reader.next((Writable)key, (Writable)value)) {
                int row_offset = (int)(key.get() - 1L);
                int rows = value.getNumRows();
                int cols = value.getNumColumns();
                if (rows == 0 || cols == 0) continue;
                if (row_offset + rows < 0 || row_offset + rows > rlen) {
                    throw new IOException("Frame block [" + (row_offset + 1) + ":" + (row_offset + rows) + ",:] out of overall frame range [1:" + rlen + ",1:" + clen + "].");
                }
                dest.copy(row_offset, row_offset + rows - 1, 0, cols - 1, value);
                if (row_offset != 0) continue;
                dest.setColumnMetadata(value.getColumnMetadata());
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameBlock readFirstBlock(String fname) throws IOException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        LongWritable key = new LongWritable();
        FrameBlock value = new FrameBlock();
        Path lpath = IOUtilFunctions.getSequenceFilePaths(fs, path)[0];
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);
        try {
            reader.next((Writable)key, (Writable)value);
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)reader);
        }
        return value;
    }
}

