/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.pollingtask;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPTransportMessage;

public class AMQPSimpleConsumerTask {
    private static Log log = LogFactory.getLog(AMQPSimpleConsumerTask.class);
    private Channel channel;
    private String queueName;
    private Map<String, Semaphore> responseTracker;
    private Map<String, AMQPTransportMessage> responseMessage;
    private ExecutorService workerPool;

    public AMQPSimpleConsumerTask(ExecutorService workerPool, Channel channel, String queueName, Map<String, Semaphore> responseTracker, Map<String, AMQPTransportMessage> responseMessage) {
        this.workerPool = workerPool;
        this.channel = channel;
        this.queueName = queueName;
        this.responseTracker = responseTracker;
        this.responseMessage = responseMessage;
    }

    public void consume() {
        this.workerPool.submit(new Consumer(this.channel, this.queueName, this.responseTracker, this.responseMessage));
    }

    private static class Consumer
    implements Runnable {
        Channel channel;
        String queueName;
        Map<String, Semaphore> responseTracker;
        Map<String, AMQPTransportMessage> responseMessage;

        private Consumer(Channel channel, String queueName, Map<String, Semaphore> responseTracker, Map<String, AMQPTransportMessage> responseMessage) {
            this.channel = channel;
            this.queueName = queueName;
            this.responseTracker = responseTracker;
            this.responseMessage = responseMessage;
        }

        @Override
        public void run() {
            try {
                this.channel.queueDeclare(this.queueName, false, false, false, null);
                QueueingConsumer queueingConsumer = new QueueingConsumer(this.channel);
                this.channel.basicConsume(this.queueName, true, (com.rabbitmq.client.Consumer)queueingConsumer);
                QueueingConsumer.Delivery delivery = queueingConsumer.nextDelivery();
                AMQPTransportMessage msg = new AMQPTransportMessage(delivery);
                this.responseMessage.put(msg.getCorrelationId(), msg);
                Semaphore semaphore = this.responseTracker.get(msg.getCorrelationId());
                semaphore.release();
            }
            catch (IOException e) {
                log.error((Object)"I/O error occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error((Object)"Retrieving task was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ShutdownSignalException e) {
                log.error((Object)"Shutdown signal was received for simple consumer task", (Throwable)e);
            }
        }
    }
}

