/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix.message;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.fix.FIXUtils;
import quickfix.InvalidMessage;
import quickfix.Message;

public class FIXMessageBuilder
implements Builder {
    private static final Log log = LogFactory.getLog(FIXMessageBuilder.class);

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        Message message;
        StringBuilder messageString = new StringBuilder();
        try {
            String charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEncoding == null) {
                charSetEncoding = "UTF-8";
            }
            InputStreamReader reader = new InputStreamReader(inputStream, charSetEncoding);
            try {
                int data = ((Reader)reader).read();
                while (data != -1) {
                    char dataChar = (char)data;
                    data = ((Reader)reader).read();
                    messageString.append(dataChar);
                }
            }
            catch (Exception e) {
                this.handleException("Error while creating FIX SOAP envelope", e);
            }
        }
        catch (Exception e) {
            this.handleException("Error while creating FIX SOAP envelope", e);
        }
        try {
            message = new Message(messageString.toString(), null, false);
        }
        catch (InvalidMessage e) {
            this.handleException("Error while creating FIX SOAP envelope", (Exception)((Object)e));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating SOAP envelope for FIX message...");
        }
        FIXUtils.getInstance().setSOAPEnvelope(message, -1, "", messageContext);
        return messageContext.getEnvelope().getBody().getFirstElement();
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

