/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.util.MessageHelper;

public class BlockingClientUtils {
    private static String[] allowedProperties = new String[]{"HTTP_METHOD", "messageType", "ContentType", "REST_URL_POSTFIX", "JSON_OBJECT", "JSON_STREAM", "JSON_STRING"};

    public static void fillClientOptions(EndpointDefinition endpoint, Options clientOptions, MessageContext synapseInMsgCtx) {
        boolean wsSecurityEnabled;
        org.apache.axis2.context.MessageContext axisInMsgCtx = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
        if (endpoint != null && (wsSecurityEnabled = endpoint.isSecurityOn())) {
            String wsSecPolicyKey = endpoint.getWsSecPolicyKey();
            if (wsSecPolicyKey != null) {
                clientOptions.setProperty("rampartPolicy", (Object)MessageHelper.getPolicy(synapseInMsgCtx, wsSecPolicyKey));
            } else {
                String inboundWsSecPolicyKey = endpoint.getInboundWsSecPolicyKey();
                String outboundWsSecPolicyKey = endpoint.getOutboundWsSecPolicyKey();
                if (inboundWsSecPolicyKey != null) {
                    clientOptions.setProperty("rampartInPolicy", (Object)MessageHelper.getPolicy(synapseInMsgCtx, inboundWsSecPolicyKey));
                }
                if (outboundWsSecPolicyKey != null) {
                    clientOptions.setProperty("rampartOutPolicy", (Object)MessageHelper.getPolicy(synapseInMsgCtx, outboundWsSecPolicyKey));
                }
            }
        }
        if (axisInMsgCtx.getSoapAction() != null) {
            clientOptions.setAction(axisInMsgCtx.getSoapAction());
        }
        clientOptions.setExceptionToBeThrownOnSOAPFault("true".equals(synapseInMsgCtx.getProperty("THROW_EXCEPTION_ON_SOAPFAULT")));
    }

    public static void fillMessageContext(EndpointDefinition endpoint, org.apache.axis2.context.MessageContext axisOutMsgCtx, MessageContext synapseInMsgCtx) throws AxisFault {
        String preserveAddressingProperty;
        boolean isRest;
        org.apache.axis2.context.MessageContext axisInMsgCtx = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
        BlockingClientUtils.setProperties(axisInMsgCtx, axisOutMsgCtx);
        if (endpoint.getFormat() != null) {
            String format = endpoint.getFormat();
            if ("pox".equals(format)) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("messageType", (Object)"application/xml");
                axisOutMsgCtx.setProperty("ContentType", (Object)"application/xml");
            } else if ("get".equals(format)) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"GET");
                axisOutMsgCtx.setProperty("messageType", (Object)"application/x-www-form-urlencoded");
            } else if ("soap11".equals(format)) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (!axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP12toSOAP11(axisOutMsgCtx);
                }
            } else if ("soap12".equals(format)) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP11toSOAP12(axisOutMsgCtx);
                }
            } else if ("rest".equals(format)) {
                if (axisInMsgCtx.getProperty("HTTP_METHOD") != null && (axisInMsgCtx.getProperty("HTTP_METHOD").toString().equals("GET") || axisInMsgCtx.getProperty("HTTP_METHOD").toString().equals("DELETE"))) {
                    axisOutMsgCtx.removeProperty("messageType");
                }
                axisOutMsgCtx.setDoingREST(true);
            }
        }
        if (endpoint.isUseMTOM()) {
            axisOutMsgCtx.setDoingMTOM(true);
            axisOutMsgCtx.setProperty("enableMTOM", (Object)"true");
            axisOutMsgCtx.setDoingMTOM(true);
        } else if (endpoint.isUseSwa()) {
            axisOutMsgCtx.setDoingSwA(true);
            axisOutMsgCtx.setProperty("enableSwA", (Object)"true");
            axisOutMsgCtx.setDoingSwA(true);
        }
        if (endpoint.getCharSetEncoding() != null) {
            axisOutMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)endpoint.getCharSetEncoding());
        }
        if (!((isRest = "rest".equals(endpoint.getFormat()) | axisInMsgCtx.isDoingREST()) || endpoint.isForceSOAP11() || endpoint.isForceSOAP12())) {
            isRest = BlockingClientUtils.isRequestRest(axisInMsgCtx);
        }
        String restURLPostfix = (String)axisOutMsgCtx.getProperty("REST_URL_POSTFIX");
        if (endpoint.getAddress() != null) {
            String address = endpoint.getAddress(synapseInMsgCtx);
            if (isRest && restURLPostfix != null && !"".equals(restURLPostfix)) {
                address = BlockingClientUtils.getEPRWithRestURLPostfix(restURLPostfix, address);
            }
            axisOutMsgCtx.setTo(new EndpointReference(address));
        } else {
            EndpointReference endpointReference = axisOutMsgCtx.getTo();
            if (endpointReference != null) {
                if (isRest && restURLPostfix != null && !"".equals(restURLPostfix)) {
                    String address = endpointReference.getAddress();
                    address = BlockingClientUtils.getEPRWithRestURLPostfix(restURLPostfix, address);
                    axisOutMsgCtx.setTo(new EndpointReference(address));
                } else {
                    axisInMsgCtx.setTo(endpointReference);
                }
            }
        }
        if (endpoint.getTimeoutDuration() > 0L) {
            int endpointTimeout = (int)endpoint.getTimeoutDuration();
            axisOutMsgCtx.setProperty("CONNECTION_TIMEOUT", (Object)endpointTimeout);
            if (endpointTimeout > 30000) {
                axisOutMsgCtx.setProperty("SO_TIMEOUT", (Object)endpointTimeout);
            }
        }
        if ((preserveAddressingProperty = (String)synapseInMsgCtx.getProperty("PRESERVE_WS_ADDRESSING")) != null && Boolean.parseBoolean(preserveAddressingProperty)) {
            axisOutMsgCtx.setMessageID(axisInMsgCtx.getMessageID());
        } else {
            MessageHelper.removeAddressingHeaders(axisOutMsgCtx);
        }
        if (endpoint.isAddressingOn()) {
            String wsAddressingVersion = endpoint.getAddressingVersion();
            if (wsAddressingVersion != null && "submission".equals(wsAddressingVersion)) {
                axisOutMsgCtx.setProperty("WSAddressingVersion", (Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            } else if (wsAddressingVersion != null && "final".equals(wsAddressingVersion)) {
                axisOutMsgCtx.setProperty("WSAddressingVersion", (Object)"http://www.w3.org/2005/08/addressing");
            }
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
        } else {
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        }
    }

    private static String getEPRWithRestURLPostfix(String restURLPostfix, String address) {
        String url = !address.endsWith("/") && !restURLPostfix.startsWith("/") && !restURLPostfix.startsWith("?") ? address + "/" + restURLPostfix : (address.endsWith("/") && restURLPostfix.startsWith("/") ? address + restURLPostfix.substring(1) : (address.endsWith("/") && restURLPostfix.startsWith("?") ? address.substring(0, address.length() - 1) + restURLPostfix : address + restURLPostfix));
        return url;
    }

    private static boolean isRequestRest(org.apache.axis2.context.MessageContext originalInMsgCtx) {
        boolean isRestRequest;
        boolean bl = isRestRequest = originalInMsgCtx.getProperty("synapse.internal.rest.contentType") != null;
        if (!isRestRequest) {
            String httpMethod = (String)originalInMsgCtx.getProperty("HTTP_METHOD");
            boolean bl2 = isRestRequest = "GET".equals(httpMethod) || "DELETE".equals(httpMethod) || "PUT".equals(httpMethod) || "OPTIONS".equals(httpMethod);
            if (!isRestRequest) {
                isRestRequest = "POST".equals(httpMethod) && HTTPTransportUtils.isRESTRequest((String)String.valueOf(originalInMsgCtx.getProperty("messageType")));
            }
        }
        return isRestRequest;
    }

    private static void setProperties(org.apache.axis2.context.MessageContext axisInMsgCtx, org.apache.axis2.context.MessageContext axisOutMsgCtx) {
        for (String propertyName : allowedProperties) {
            Object property = axisInMsgCtx.getProperty(propertyName);
            if (property == null) continue;
            axisOutMsgCtx.setProperty(propertyName, property);
        }
    }
}

