/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabParameter;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.VariableReturnValue;
import net.sf.jasperreports.engine.analytics.dataset.FillMultiAxisData;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisData;
import net.sf.jasperreports.engine.base.JRBaseConditionalStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillBreak;
import net.sf.jasperreports.engine.fill.JRFillComponentElement;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillEllipse;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillExpressionReturnValue;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRFillGenericElement;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillImage;
import net.sf.jasperreports.engine.fill.JRFillLine;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillRectangle;
import net.sf.jasperreports.engine.fill.JRFillReportTemplate;
import net.sf.jasperreports.engine.fill.JRFillSection;
import net.sf.jasperreports.engine.fill.JRFillStaticText;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillTextField;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRFillVariableReturnValue;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillObjectFactory
extends JRAbstractObjectFactory {
    private static final Log log = LogFactory.getLog(JRFillObjectFactory.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNRESOLVED_STYLE = "fill.object.factory.unresolved.style";
    public static final String EXCEPTION_MESSAGE_KEY_STYLE_NOT_FOUND = "fill.object.factory.style.not.found";
    protected JRBaseFiller filler;
    protected BaseReportFiller reportFiller;
    private JRFillExpressionEvaluator evaluator;
    private JRFillObjectFactory parentFiller;
    private List<JRFillElementDataset> elementDatasets = new ArrayList<JRFillElementDataset>();
    private Map<String, List<JRFillElementDataset>> elementDatasetMap = new HashMap<String, List<JRFillElementDataset>>();
    private LinkedList<List<JRFillDatasetRun>> trackedDatasetRunsStack = new LinkedList();
    private Map<String, List<JRStyleSetter>> delayedStyleSettersByName = new HashMap<String, List<JRStyleSetter>>();
    private Set<JRStyle> originalStyleList;
    protected StylesList stylesMap = new StylesList();

    protected JRFillObjectFactory(JRBaseFiller filler) {
        this(filler, (JRFillExpressionEvaluator)filler.calculator);
    }

    public JRFillObjectFactory(JRBaseFiller filler, JRFillExpressionEvaluator expressionEvaluator) {
        this.filler = filler;
        this.reportFiller = filler;
        this.evaluator = expressionEvaluator;
    }

    public JRFillObjectFactory(JRFillObjectFactory parent, JRFillExpressionEvaluator expressionEvaluator) {
        this.parentFiller = parent;
        this.filler = parent.filler;
        this.reportFiller = parent.reportFiller;
        this.evaluator = expressionEvaluator;
    }

    public JRFillObjectFactory(BaseReportFiller reportFiller) {
        this.reportFiller = reportFiller;
        this.evaluator = reportFiller.calculator;
    }

    public JRFillExpressionEvaluator getExpressionEvaluator() {
        return this.evaluator;
    }

    protected JRFillElementDataset[] getElementDatasets(JRDataset dataset) {
        JRFillElementDataset[] elementDatasetsArray;
        List<JRFillElementDataset> elementDatasetsList = dataset.isMainDataset() ? this.elementDatasets : this.elementDatasetMap.get(dataset.getName());
        if (elementDatasetsList == null || elementDatasetsList.size() == 0) {
            elementDatasetsArray = new JRFillElementDataset[]{};
        } else {
            elementDatasetsArray = new JRFillElementDataset[elementDatasetsList.size()];
            elementDatasetsList.toArray(elementDatasetsArray);
        }
        return elementDatasetsArray;
    }

    protected void registerDelayedStyleSetter(JRStyleSetter delayedSetter, String styleName) {
        if (this.parentFiller == null) {
            List<JRStyleSetter> setters = this.delayedStyleSettersByName.get(styleName);
            if (setters == null) {
                setters = new ArrayList<JRStyleSetter>();
                this.delayedStyleSettersByName.put(styleName, setters);
            }
            setters.add(delayedSetter);
        } else {
            this.parentFiller.registerDelayedStyleSetter(delayedSetter, styleName);
        }
    }

    public void registerDelayedStyleSetter(JRStyleSetter delayedSetter, JRStyleContainer styleContainer) {
        JRStyle style = styleContainer.getStyle();
        String nameReference = styleContainer.getStyleNameReference();
        if (style != null) {
            this.registerDelayedStyleSetter(delayedSetter, style.getName());
        } else if (nameReference != null) {
            this.registerDelayedStyleSetter(delayedSetter, nameReference);
        }
    }

    @Override
    public JRBaseStyle getStyle(JRStyle style) {
        JRBaseStyle fillStyle = null;
        if (style != null && (fillStyle = (JRBaseStyle)this.get(style)) == null) {
            fillStyle = new JRBaseStyle(style, this);
            fillStyle = this.filler.fillContext.deduplicate(fillStyle);
            this.put(style, fillStyle);
            if (this.originalStyleList != null && this.originalStyleList.contains(style)) {
                this.renameExistingStyle(style.getName());
                this.stylesMap.addStyle(style);
            }
        }
        return fillStyle;
    }

    protected void renameExistingStyle(String name) {
        JRStyle originalStyle = this.stylesMap.getStyle(name);
        if (originalStyle != null) {
            String newName;
            JRBaseStyle style = (JRBaseStyle)this.get(originalStyle);
            int suf = 1;
            do {
                newName = name + suf;
                ++suf;
            } while (this.stylesMap.containsStyle(newName));
            style.rename(newName);
            this.stylesMap.renamed(name, newName);
        }
    }

    @Override
    public void setStyle(JRStyleSetter setter, JRStyleContainer styleContainer) {
        JRStyle style = styleContainer.getStyle();
        String nameReference = styleContainer.getStyleNameReference();
        if (style != null) {
            JRBaseStyle newStyle = this.getStyle(style);
            setter.setStyle(newStyle);
        } else if (nameReference != null) {
            JRStyle originalStyle = this.stylesMap.getStyle(nameReference);
            if (originalStyle == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNRESOLVED_STYLE, nameReference);
            }
            JRStyle externalStyle = (JRStyle)this.get(originalStyle);
            setter.setStyle(externalStyle);
        }
    }

    protected JRFillParameter getParameter(JRParameter parameter) {
        JRFillParameter fillParameter = null;
        if (parameter != null && (fillParameter = (JRFillParameter)this.get(parameter)) == null) {
            fillParameter = new JRFillParameter(parameter, this);
        }
        return fillParameter;
    }

    protected JRFillField getField(JRField field) {
        JRFillField fillField = null;
        if (field != null && (fillField = (JRFillField)this.get(field)) == null) {
            fillField = new JRFillField(field, this);
        }
        return fillField;
    }

    public JRFillVariable getVariable(JRVariable variable) {
        JRFillVariable fillVariable = null;
        if (variable != null && (fillVariable = (JRFillVariable)this.get(variable)) == null) {
            fillVariable = new JRFillVariable(variable, this);
        }
        return fillVariable;
    }

    public JRFillGroup getGroup(JRGroup group) {
        JRFillGroup fillGroup = null;
        if (group != null && (fillGroup = (JRFillGroup)this.get(group)) == null) {
            fillGroup = new JRFillGroup(group, this);
        }
        return fillGroup;
    }

    protected JRFillSection getSection(JRSection section) {
        JRFillSection fillSection = null;
        if (section == null) {
            fillSection = this.filler.missingFillSection;
        } else {
            fillSection = (JRFillSection)this.get(section);
            if (fillSection == null) {
                fillSection = new JRFillSection(this.filler, section, this);
            }
        }
        return fillSection;
    }

    protected JRFillBand getBand(JRBand band) {
        JRFillBand fillBand = null;
        if (band == null) {
            fillBand = this.filler.missingFillBand;
        } else {
            fillBand = (JRFillBand)this.get(band);
            if (fillBand == null) {
                fillBand = new JRFillBand(this.filler, band, this);
            }
        }
        return fillBand;
    }

    @Override
    public void visitElementGroup(JRElementGroup elementGroup) {
        JRFillElementGroup fillElementGroup = null;
        if (elementGroup != null && (fillElementGroup = (JRFillElementGroup)this.get(elementGroup)) == null) {
            fillElementGroup = new JRFillElementGroup(elementGroup, this);
        }
        this.setVisitResult(fillElementGroup);
    }

    @Override
    public void visitBreak(JRBreak breakElement) {
        JRFillBreak fillBreak = null;
        if (breakElement != null && (fillBreak = (JRFillBreak)this.get(breakElement)) == null) {
            fillBreak = new JRFillBreak(this.filler, breakElement, this);
        }
        this.setVisitResult(fillBreak);
    }

    @Override
    public void visitLine(JRLine line) {
        JRFillLine fillLine = null;
        if (line != null && (fillLine = (JRFillLine)this.get(line)) == null) {
            fillLine = new JRFillLine(this.filler, line, this);
        }
        this.setVisitResult(fillLine);
    }

    @Override
    public void visitRectangle(JRRectangle rectangle) {
        JRFillRectangle fillRectangle = null;
        if (rectangle != null && (fillRectangle = (JRFillRectangle)this.get(rectangle)) == null) {
            fillRectangle = new JRFillRectangle(this.filler, rectangle, this);
        }
        this.setVisitResult(fillRectangle);
    }

    @Override
    public void visitEllipse(JREllipse ellipse) {
        JRFillEllipse fillEllipse = null;
        if (ellipse != null && (fillEllipse = (JRFillEllipse)this.get(ellipse)) == null) {
            fillEllipse = new JRFillEllipse(this.filler, ellipse, this);
        }
        this.setVisitResult(fillEllipse);
    }

    @Override
    public void visitImage(JRImage image) {
        JRFillImage fillImage = null;
        if (image != null && (fillImage = (JRFillImage)this.get(image)) == null) {
            fillImage = new JRFillImage(this.filler, image, this);
        }
        this.setVisitResult(fillImage);
    }

    @Override
    public void visitStaticText(JRStaticText staticText) {
        JRFillStaticText fillStaticText = null;
        if (staticText != null && (fillStaticText = (JRFillStaticText)this.get(staticText)) == null) {
            fillStaticText = new JRFillStaticText(this.filler, staticText, this);
        }
        this.setVisitResult(fillStaticText);
    }

    @Override
    public void visitTextField(JRTextField textField) {
        JRFillTextField fillTextField = null;
        if (textField != null && (fillTextField = (JRFillTextField)this.get(textField)) == null) {
            fillTextField = new JRFillTextField(this.filler, textField, this);
        }
        this.setVisitResult(fillTextField);
    }

    @Override
    public void visitSubreport(JRSubreport subreport) {
        JRFillSubreport fillSubreport = null;
        if (subreport != null && (fillSubreport = (JRFillSubreport)this.get(subreport)) == null) {
            fillSubreport = new JRFillSubreport(this.filler, subreport, this);
        }
        this.setVisitResult(fillSubreport);
    }

    protected JRFillVariableReturnValue getSubreportReturnValue(JRSubreportReturnValue returnValue) {
        JRFillVariableReturnValue fillReturnValue = null;
        if (returnValue != null && (fillReturnValue = (JRFillVariableReturnValue)this.get(returnValue)) == null) {
            fillReturnValue = new JRFillVariableReturnValue(returnValue, this, this.reportFiller);
        }
        return fillReturnValue;
    }

    protected JRFillVariableReturnValue getReturnValue(VariableReturnValue returnValue) {
        JRFillVariableReturnValue fillReturnValue = null;
        if (returnValue != null && (fillReturnValue = (JRFillVariableReturnValue)this.get(returnValue)) == null) {
            fillReturnValue = new JRFillVariableReturnValue(returnValue, this, (BaseReportFiller)this.filler);
        }
        return fillReturnValue;
    }

    protected JRFillExpressionReturnValue getReturnValue(ExpressionReturnValue returnValue) {
        JRFillExpressionReturnValue fillReturnValue = null;
        if (returnValue != null && (fillReturnValue = (JRFillExpressionReturnValue)this.get(returnValue)) == null) {
            fillReturnValue = new JRFillExpressionReturnValue(returnValue, this, (BaseReportFiller)this.filler);
        }
        return fillReturnValue;
    }

    @Override
    public void visitCrosstab(JRCrosstab crosstabElement) {
        JRFillCrosstab fillCrosstab = null;
        if (crosstabElement != null && (fillCrosstab = (JRFillCrosstab)this.get(crosstabElement)) == null) {
            fillCrosstab = new JRFillCrosstab(this.filler, crosstabElement, this);
        }
        this.setVisitResult(fillCrosstab);
    }

    public JRFillCrosstab.JRFillCrosstabDataset getCrosstabDataset(JRCrosstabDataset dataset, JRFillCrosstab fillCrosstab) {
        JRFillCrosstab.JRFillCrosstabDataset fillDataset = null;
        if (dataset != null && (fillDataset = (JRFillCrosstab.JRFillCrosstabDataset)this.get(dataset)) == null) {
            JRFillCrosstab jRFillCrosstab = fillCrosstab;
            Objects.requireNonNull(jRFillCrosstab);
            fillDataset = jRFillCrosstab.new JRFillCrosstab.JRFillCrosstabDataset(dataset, this);
            this.registerElementDataset(fillDataset);
        }
        return fillDataset;
    }

    public JRFillDataset getDataset(JRDataset dataset) {
        JRFillDataset fillDataset = null;
        if (dataset != null && (fillDataset = (JRFillDataset)this.get(dataset)) == null) {
            fillDataset = new JRFillDataset(this.reportFiller, dataset, this);
        }
        return fillDataset;
    }

    public void registerElementDataset(JRFillElementDataset elementDataset) {
        List<JRFillElementDataset> elementDatasetsList;
        JRDatasetRun datasetRun = elementDataset.getDatasetRun();
        if (datasetRun == null) {
            elementDatasetsList = this.elementDatasets;
        } else {
            String datasetName = datasetRun.getDatasetName();
            elementDatasetsList = this.getElementDatasetsList(datasetName);
            this.registerDatasetRun((JRFillDatasetRun)datasetRun);
        }
        elementDatasetsList.add(elementDataset);
    }

    protected List<JRFillElementDataset> getElementDatasetsList(String datasetName) {
        if (this.parentFiller != null) {
            return this.parentFiller.getElementDatasetsList(datasetName);
        }
        List<JRFillElementDataset> elementDatasetsList = this.elementDatasetMap.get(datasetName);
        if (elementDatasetsList == null) {
            elementDatasetsList = new ArrayList<JRFillElementDataset>();
            this.elementDatasetMap.put(datasetName, elementDatasetsList);
        }
        return elementDatasetsList;
    }

    public void trackDatasetRuns() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"tracking dataset runs");
        }
        ArrayList trackedDatasets = new ArrayList(2);
        this.trackedDatasetRunsStack.push(trackedDatasets);
    }

    public void registerDatasetRun(JRFillDatasetRun datasetRun) {
        if (!this.trackedDatasetRunsStack.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("added tracked dataset run " + datasetRun));
            }
            this.trackedDatasetRunsStack.getFirst().add(datasetRun);
        }
    }

    public List<JRFillDatasetRun> getTrackedDatasetRuns() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"poping tracked dataset runs");
        }
        return this.trackedDatasetRunsStack.pop();
    }

    public JRFillDatasetRun getDatasetRun(JRDatasetRun datasetRun) {
        JRFillDatasetRun fillDatasetRun = null;
        if (datasetRun != null && (fillDatasetRun = (JRFillDatasetRun)this.get(datasetRun)) == null) {
            fillDatasetRun = new JRFillDatasetRun(datasetRun, this);
        }
        return fillDatasetRun;
    }

    public JRFillCrosstabParameter getCrosstabParameter(JRCrosstabParameter parameter) {
        JRFillCrosstabParameter fillParameter = null;
        if (parameter != null && (fillParameter = (JRFillCrosstabParameter)this.get(parameter)) == null) {
            fillParameter = new JRFillCrosstabParameter(parameter, this);
        }
        return fillParameter;
    }

    @Override
    public void visitFrame(JRFrame frame) {
        Object fillFrame = null;
        if (frame != null && (fillFrame = this.get(frame)) == null) {
            fillFrame = new JRFillFrame(this.filler, frame, this);
        }
        this.setVisitResult(fillFrame);
    }

    public BaseReportFiller getReportFiller() {
        return this.reportFiller;
    }

    public JRBaseFiller getFiller() {
        return this.filler;
    }

    @Override
    public JRConditionalStyle getConditionalStyle(JRConditionalStyle conditionalStyle, JRStyle style) {
        JRBaseConditionalStyle baseConditionalStyle = null;
        if (conditionalStyle != null && (baseConditionalStyle = (JRBaseConditionalStyle)this.get(conditionalStyle)) == null) {
            baseConditionalStyle = new JRBaseConditionalStyle(conditionalStyle, style, this);
            this.put(conditionalStyle, baseConditionalStyle);
        }
        return baseConditionalStyle;
    }

    @Override
    public JRExpression getExpression(JRExpression expression, boolean assignNotUsedId) {
        return expression;
    }

    public JRFillReportTemplate getReportTemplate(JRReportTemplate template) {
        JRFillReportTemplate fillTemplate = null;
        if (template != null && (fillTemplate = (JRFillReportTemplate)this.get(template)) == null) {
            fillTemplate = new JRFillReportTemplate(template, this.filler, this);
        }
        return fillTemplate;
    }

    public List<JRStyle> setStyles(List<JRStyle> styles) {
        this.originalStyleList = new HashSet<JRStyle>(styles);
        Set<JRStyle> requestedStyles = this.collectRequestedStyles(styles);
        LinkedMap usedStylesMap = new LinkedMap();
        HashMap<String, JRStyle> allStylesMap = new HashMap<String, JRStyle>();
        for (JRStyle style : styles) {
            if (requestedStyles.contains(style)) {
                this.collectUsedStyles(style, (Map<JRStyle, Object>)usedStylesMap, allStylesMap);
            }
            allStylesMap.put(style.getName(), style);
        }
        ArrayList<JRStyle> includedStyles = new ArrayList<JRStyle>();
        for (JRStyle style : usedStylesMap.keySet()) {
            JRBaseStyle newStyle = this.getStyle(style);
            includedStyles.add(newStyle);
            if (!requestedStyles.contains(style)) continue;
            this.useDelayedStyle(newStyle);
        }
        this.checkUnresolvedReferences();
        return includedStyles;
    }

    protected Set<JRStyle> collectRequestedStyles(List<JRStyle> externalStyles) {
        HashMap<String, JRStyle> requestedStylesMap = new HashMap<String, JRStyle>();
        for (JRStyle style : externalStyles) {
            String name = style.getName();
            if (!this.delayedStyleSettersByName.containsKey(name)) continue;
            requestedStylesMap.put(name, style);
        }
        return new HashSet<JRStyle>(requestedStylesMap.values());
    }

    protected void collectUsedStyles(JRStyle style, Map<JRStyle, Object> usedStylesMap, Map<String, JRStyle> allStylesMap) {
        if (!usedStylesMap.containsKey(style) && this.originalStyleList.contains(style)) {
            String parentName;
            JRStyle parent = style.getStyle();
            if (parent == null && (parentName = style.getStyleNameReference()) != null && (parent = allStylesMap.get(parentName)) == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_STYLE_NOT_FOUND, parentName);
            }
            if (parent != null) {
                this.collectUsedStyles(parent, usedStylesMap, allStylesMap);
            }
            usedStylesMap.put(style, null);
        }
    }

    protected void useDelayedStyle(JRStyle style) {
        List<JRStyleSetter> delayedSetters = this.delayedStyleSettersByName.remove(style.getName());
        if (delayedSetters != null) {
            for (JRStyleSetter setter : delayedSetters) {
                setter.setStyle(style);
            }
        }
    }

    protected void checkUnresolvedReferences() {
        if (!this.delayedStyleSettersByName.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            for (String name : this.delayedStyleSettersByName.keySet()) {
                errorMsg.append(name);
                errorMsg.append(", ");
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNRESOLVED_STYLE, errorMsg.substring(0, errorMsg.length() - 2));
        }
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.filler.getJasperPrint().getDefaultStyleProvider();
    }

    @Override
    public void visitComponentElement(JRComponentElement componentElement) {
        JRFillComponentElement fill = null;
        if (componentElement != null && (fill = (JRFillComponentElement)this.get(componentElement)) == null) {
            fill = new JRFillComponentElement(this.filler, componentElement, this);
        }
        this.setVisitResult(fill);
    }

    @Override
    public void visitGenericElement(JRGenericElement element) {
        JRFillGenericElement fill = null;
        if (element != null && (fill = (JRFillGenericElement)this.get(element)) == null) {
            fill = new JRFillGenericElement(this.filler, element, this);
        }
        this.setVisitResult(fill);
    }

    public FillMultiAxisData getBidimensionalData(MultiAxisData data) {
        FillMultiAxisData fillData = null;
        if (data != null && (fillData = (FillMultiAxisData)this.get(data)) == null) {
            fillData = new FillMultiAxisData(data, this);
        }
        return fillData;
    }

    protected static class StylesList {
        private final List<JRStyle> styles = new ArrayList<JRStyle>();
        private final Map<String, Integer> stylesIdx = new HashMap<String, Integer>();

        protected StylesList() {
        }

        public boolean containsStyle(String name) {
            return this.stylesIdx.containsKey(name);
        }

        public JRStyle getStyle(String name) {
            Integer idx = this.stylesIdx.get(name);
            return idx == null ? null : this.styles.get(idx);
        }

        public void addStyle(JRStyle style) {
            this.styles.add(style);
            this.stylesIdx.put(style.getName(), this.styles.size() - 1);
        }

        public void renamed(String oldName, String newName) {
            Integer idx = this.stylesIdx.remove(oldName);
            this.stylesIdx.put(newName, idx);
        }
    }
}

