/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.sf.oval.internal.util.Assert;

public final class ObjectCache<K, V> {
    private final ConcurrentMap<K, SoftRef<K, V>> map = new ConcurrentHashMap<K, SoftRef<K, V>>();
    private final ReferenceQueue<V> garbageCollectedValues = new ReferenceQueue();
    private final Function<K, V> loader;

    public ObjectCache(Function<K, V> loader) {
        Assert.argumentNotNull("loader", loader);
        this.loader = loader;
    }

    private void compact() {
        Reference<V> ref;
        while ((ref = this.garbageCollectedValues.poll()) != null) {
            this.map.remove(((SoftRef)ref).key, ref);
        }
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public V get(K key) {
        this.compact();
        SoftRef softRef = (SoftRef)this.map.get(key);
        Object result = null;
        if (softRef != null) {
            Object value = softRef.get();
            if (value == null) {
                this.map.remove(key);
            }
            result = softRef.get();
        }
        if (result == null) {
            result = this.loader.apply(key);
            this.map.remove(key);
            this.map.put(key, new SoftRef<K, Object>(key, result, (ReferenceQueue<Object>)this.garbageCollectedValues));
        }
        return result;
    }

    private static final class SoftRef<K, V>
    extends SoftReference<V> {
        final K key;

        SoftRef(K key, V value, ReferenceQueue<? super V> q) {
            super(value, q);
            this.key = key;
        }
    }
}

