/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Util;
import java.util.Collections;
import java.util.List;

public class Constructor
extends AbstractNode {
    private final ImmutableList<JavaAnnotation> javaAnnotations;
    private final ImmutableList<Parameter> parameters;

    public Constructor(SourcePosition sourcePosition, String displayName, List<JavaAnnotation> javaAnnotations, List<Parameter> parameters) {
        super(sourcePosition, displayName);
        this.javaAnnotations = ImmutableList.copyOf(javaAnnotations);
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public Constructor(Node fromNode, List<JavaAnnotation> javaAnnotations, List<Parameter> parameters) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName(), javaAnnotations, parameters);
    }

    public static Constructor empty(SourcePosition sourcePosition, String displayName) {
        return new Constructor(sourcePosition, displayName, Collections.<JavaAnnotation>emptyList(), Collections.<Parameter>emptyList());
    }

    public static Constructor empty(Node fromNode) {
        return Constructor.empty(fromNode.getSourcePosition(), fromNode.getDisplayName());
    }

    public Constructor withParameters(List<Parameter> newParameters) {
        return Iterables.elementsEqual(this.parameters, newParameters) ? this : new Constructor(this, this.javaAnnotations, newParameters);
    }

    public Constructor transformParameters(Function<Parameter, Parameter> parameterTransformer) {
        ImmutableList<Parameter> newParameters = Util.map(this.parameters, parameterTransformer);
        return this.withParameters(newParameters);
    }

    public List<JavaAnnotation> getJavaAnnotations() {
        return this.javaAnnotations;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Constructor && this.equals((Constructor)that);
    }

    public boolean equals(Constructor that) {
        return this.equalsAbstractNode(that) && Objects.equal(this.getJavaAnnotations(), that.getJavaAnnotations()) && Objects.equal(this.getParameters(), that.getParameters());
    }

    public int hashCode() {
        return Objects.hashCode(this.abstractNodeHashCode(), this.getJavaAnnotations(), this.getParameters());
    }
}

