/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.base.dynamic;

import com.google.gxp.base.GxpTemplate;
import com.google.gxp.base.dynamic.GxpCompilationException;
import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.com.google.common.base.Predicate;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.io.Bytes;
import com.google.gxp.com.google.common.io.Characters;
import com.google.gxp.compiler.CompilationSet;
import com.google.gxp.compiler.SimpleCompilationManager;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSet;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.CodeGeneratorFactory;
import com.google.gxp.compiler.codegen.DefaultCodeGeneratorFactory;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileSystem;
import com.google.gxp.compiler.fs.InMemoryFileSystem;
import com.google.gxp.compiler.fs.JavaFileManagerImpl;
import com.google.gxp.compiler.fs.JavaFileRef;
import com.google.gxp.compiler.fs.SourcePathFileSystem;
import com.google.gxp.compiler.fs.SystemFileSystem;
import com.google.gxp.compiler.parser.FileSystemEntityResolver;
import com.google.gxp.compiler.parser.Parser;
import com.google.gxp.compiler.parser.SaxXmlParser;
import com.google.gxp.compiler.schema.BuiltinSchemaFactory;
import com.google.gxp.compiler.schema.DelegatingSchemaFactory;
import com.google.gxp.compiler.schema.FileBackedSchemaFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class StubGxpTemplate
extends GxpTemplate {
    protected static FileSystem systemFS = SystemFileSystem.INSTANCE;
    private static final CodeGeneratorFactory codeGeneratorFactory = new DefaultCodeGeneratorFactory();
    private static final Set<OutputLanguage> OUTPUT_LANGUAGES = Collections.singleton(OutputLanguage.DYNAMIC_IMPL_JAVA);
    private static JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
    private static final Method DEFINE_CLASS = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                Class<ClassLoader> loader = ClassLoader.class;
                Method m = loader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException();
            }
        }
    });
    private static final ProtectionDomain PROTECTION_DOMAIN = StubGxpTemplate.class.getProtectionDomain();
    private static final Pattern LINE_DIRECTIVE = Pattern.compile("^.* // (.*): L(\\d*), C(\\d*)$");

    public static void setSystemFileSystem(FileSystem systemFS) {
        StubGxpTemplate.systemFS = systemFS;
    }

    public static void setJavaCompiler(JavaCompiler javaCompiler) {
        StubGxpTemplate.javaCompiler = javaCompiler;
    }

    protected static FileRef parseFilename(String filename) {
        return systemFS.parseFilename(filename);
    }

    protected static List<FileRef> parseFilenameList(String ... filenames) {
        ArrayList<FileRef> fileRefs = Lists.newArrayList();
        for (String filename : filenames) {
            fileRefs.add(StubGxpTemplate.parseFilename(filename));
        }
        return fileRefs;
    }

    protected static AlertPolicy createAlertPolicy(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (AlertPolicy)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static FileRef compileGxp(InMemoryFileSystem outFs, List<FileRef> srcGxps, List<FileRef> srcSchemas, List<FileRef> srcPaths, String javaBase, long compilationVersion, AlertPolicy alertPolicy) throws GxpCompilationException {
        SourcePathFileSystem sourcePathFs = new SourcePathFileSystem(systemFS, srcPaths, srcGxps, outFs.getRoot());
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder();
        DelegatingSchemaFactory schemaFactory = new DelegatingSchemaFactory(new FileBackedSchemaFactory(alertSetBuilder, srcSchemas), new BuiltinSchemaFactory(alertSetBuilder));
        Parser parser = new Parser(schemaFactory, SaxXmlParser.INSTANCE, new FileSystemEntityResolver(sourcePathFs));
        CompilationSet set = new CompilationSet.Builder(parser, codeGeneratorFactory, SimpleCompilationManager.INSTANCE).setCompilationVersion(compilationVersion).build(sourcePathFs.getSourceFileRefs());
        final String javaFile = javaBase + compilationVersion + ".java";
        Predicate<FileRef> shouldCompileFilePredicate = new Predicate<FileRef>(){

            @Override
            public boolean apply(FileRef fnam) {
                return fnam.toFilename().equals(javaFile);
            }
        };
        set.compile(alertSetBuilder, alertPolicy, OUTPUT_LANGUAGES, shouldCompileFilePredicate);
        AlertSet aset = alertSetBuilder.buildAndClear();
        if (aset.hasErrors(alertPolicy)) {
            throw new GxpCompilationException.Gxp(alertPolicy, aset);
        }
        return outFs.parseFilename(javaFile);
    }

    protected static Map<String, Method> compileJava(InMemoryFileSystem outFs, String classBase, long compilationVersion) {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        JavaFileManagerImpl javaFileManager = new JavaFileManagerImpl(javaCompiler.getStandardFileManager(diagnosticCollector, Locale.US, Charsets.US_ASCII), outFs);
        String className = classBase + compilationVersion;
        try {
            int oldCount;
            int newCount;
            JavaFileObject compilationUnit = javaFileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, className, JavaFileObject.Kind.SOURCE);
            ImmutableList<JavaFileObject> compilationUnits = ImmutableList.of(compilationUnit);
            javaCompiler.getTask(null, javaFileManager, diagnosticCollector, null, null, compilationUnits).call();
            List<Diagnostic<? extends JavaFileObject>> diagnostics = StubGxpTemplate.filterErrors(diagnosticCollector.getDiagnostics());
            if (!diagnostics.isEmpty()) {
                throw new GxpCompilationException.Java(diagnostics);
            }
            List<byte[]> classFiles = Lists.newArrayList();
            for (FileRef fileRef : outFs.getManifest()) {
                String outputClassName;
                if (!fileRef.getKind().equals((Object)JavaFileObject.Kind.CLASS) || !(outputClassName = javaFileManager.inferBinaryName(StandardLocation.CLASS_OUTPUT, new JavaFileRef(fileRef))).equals(className) && !outputClassName.startsWith(className + "$")) continue;
                classFiles.add(Bytes.toByteArray(fileRef.openInputStream()));
            }
            do {
                oldCount = classFiles.size();
            } while ((newCount = (classFiles = StubGxpTemplate.defineClasses(classFiles)).size()) != 0 && newCount != oldCount);
            Class<?> c = Class.forName(className);
            return StubGxpTemplate.getMethodMap(c);
        }
        catch (GxpCompilationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GxpCompilationException.Throw(e);
        }
    }

    protected static Map<String, Method> getMethodMap(Class c) {
        HashMap<String, Method> map = Maps.newHashMap();
        for (Method method : c.getMethods()) {
            map.put(method.getName(), method);
        }
        return map;
    }

    private static List<byte[]> defineClasses(List<byte[]> classFiles) throws Throwable {
        ArrayList<byte[]> failures = Lists.newArrayList();
        for (byte[] classFile : classFiles) {
            try {
                StubGxpTemplate.defineClass(classFile);
            }
            catch (NoClassDefFoundError e) {
                failures.add(classFile);
            }
        }
        return failures;
    }

    protected static Object exec(Map<String, Method> methods, String function, Object[] args) throws Throwable {
        try {
            return methods.get(function).invoke(null, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Exception e) {
            throw new GxpCompilationException.Throw(e);
        }
    }

    protected static <T> T execNoExceptions(Map<String, Method> methods, String function, Object[] args) {
        try {
            Object result = StubGxpTemplate.exec(methods, function, args);
            return (T)result;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new GxpCompilationException.Throw(t);
        }
    }

    private static <T> List<Diagnostic<? extends T>> filterErrors(List<Diagnostic<? extends T>> diagnostics) {
        ArrayList<Diagnostic<? extends T>> newList = Lists.newArrayList();
        for (Diagnostic<T> diagnostic : diagnostics) {
            if (!diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) continue;
            newList.add(diagnostic);
        }
        return Collections.unmodifiableList(newList);
    }

    private static Class defineClass(byte[] classFile) throws Throwable {
        Object[] args = new Object[]{null, classFile, new Integer(0), new Integer(classFile.length), PROTECTION_DOMAIN};
        try {
            return (Class)DEFINE_CLASS.invoke((Object)ClassLoader.getSystemClassLoader(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected static void rewriteStackTraceElements(Throwable throwable, FileRef sourceFile) {
        try {
            if (sourceFile != null) {
                String sourceFileName = sourceFile.getName().substring(1).replace('/', '.');
                StackTraceElement[] stackTrace = throwable.getStackTrace();
                for (int i = 0; i < stackTrace.length; ++i) {
                    if (!sourceFileName.equals(stackTrace[i].getFileName())) continue;
                    String[] parts = sourceFileName.split("[\\.\\$]");
                    String sourceName = parts[parts.length - 3] + ".gxp";
                    String line = Characters.readLines(sourceFile.openReader(Charsets.UTF_8)).get(stackTrace[i].getLineNumber() - 1);
                    Matcher m = LINE_DIRECTIVE.matcher(line);
                    int sourceLine = m.find() ? Integer.valueOf(m.group(2)) : -1;
                    String className = stackTrace[i].getClassName().split("\\$")[0];
                    stackTrace[i] = new StackTraceElement(className, stackTrace[i].getMethodName(), sourceName, sourceLine);
                    throwable.setStackTrace(stackTrace);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

