/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

class JarDecompressor {
    private static final int BUFFER_SIZE = 16384;

    JarDecompressor() {
    }

    static void copyDecompress(File in, File out) throws IOException {
        if (JarDecompressor.decompress(in, out)) {
            return;
        }
        FileUtils.copyFile((File)in, (File)out);
    }

    private static boolean decompress(File in, File out) throws IOException {
        try (JarInputStream jis = new JarInputStream(new FileInputStream(in));
             JarOutputStream jos = new JarOutputStream(new FileOutputStream(out));){
            jos.setMethod(0);
            JarDecompressor.writeManifestIfPresent(jis, jos);
            byte[] buffer = new byte[16384];
            JarEntry je = null;
            while ((je = jis.getNextJarEntry()) != null) {
                if ("META-INF/MANIFEST.MF".equals(je.getName())) continue;
                if (je.getName().startsWith("META-INF/") && je.getName().endsWith(".SF")) {
                    boolean bl = false;
                    return bl;
                }
                File tmpFile = Files.createTempFile("tempfile", ".tmp", new FileAttribute[0]).toFile();
                try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                    JarDecompressor.drainStream(jis, fos, buffer);
                }
                if (je.getName().toLowerCase().endsWith(".jar")) {
                    File tmpFile2 = tmpFile;
                    tmpFile = Files.createTempFile("tempfile", ".tmp", new FileAttribute[0]).toFile();
                    JarDecompressor.copyDecompress(tmpFile2, tmpFile);
                    if (!tmpFile2.delete()) {
                        throw new IOException("Could not delete temp file " + tmpFile);
                    }
                }
                ZipEntry ze = new ZipEntry(je);
                JarDecompressor.crcEntry(ze, tmpFile, buffer);
                ((ZipOutputStream)jos).putNextEntry(ze);
                try (FileInputStream is = new FileInputStream(tmpFile);){
                    JarDecompressor.drainStream(is, jos, buffer);
                }
                jos.closeEntry();
                if (tmpFile.delete()) continue;
                throw new IOException("Could not delete temp file " + tmpFile);
            }
        }
        return true;
    }

    private static void drainStream(InputStream is, OutputStream os, byte[] buf) throws IOException {
        int sz = 0;
        while ((sz = is.read(buf)) > 0) {
            os.write(buf, 0, sz);
        }
    }

    private static void crcEntry(ZipEntry ze, File f, byte[] buf) throws IOException {
        try (SizeAndCrcComputeStream cs = new SizeAndCrcComputeStream();){
            try (FileInputStream is = new FileInputStream(f);){
                JarDecompressor.drainStream(is, cs, buf);
            }
            cs.updateZipEntry(ze);
        }
    }

    private static void crcEntryManifestEntry(ZipEntry ze, Manifest mf) throws IOException {
        SizeAndCrcComputeStream cs = new SizeAndCrcComputeStream();
        mf.write(cs);
        cs.updateZipEntry(ze);
    }

    private static void writeManifestIfPresent(JarInputStream jis, ZipOutputStream jos) throws IOException {
        Manifest manifest = jis.getManifest();
        if (manifest == null) {
            return;
        }
        ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
        JarDecompressor.crcEntryManifestEntry(e, manifest);
        jos.putNextEntry(e);
        manifest.write(new BufferedOutputStream(jos));
        jos.closeEntry();
    }

    private static class SizeAndCrcComputeStream
    extends OutputStream {
        final CRC32 crc = new CRC32();
        long sizeCounter = 0L;

        private SizeAndCrcComputeStream() {
        }

        @Override
        public void write(int r) throws IOException {
            ++this.sizeCounter;
            this.crc.update(r);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.sizeCounter += (long)len;
            this.crc.update(b, off, len);
        }

        public void updateZipEntry(ZipEntry e) {
            e.setSize(this.sizeCounter);
            e.setCompressedSize(this.sizeCounter);
            e.setCrc(this.crc.getValue());
            e.setMethod(0);
        }
    }
}

