/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.deploy.method;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.sling.maven.bundlesupport.deploy.DeployContext;
import org.apache.sling.maven.bundlesupport.deploy.DeployMethod;

public class SlingPostDeployMethod
implements DeployMethod {
    @Override
    public void deploy(URI targetURL, File file, String bundleSymbolicName, DeployContext context) throws IOException {
        targetURL = SlingPostDeployMethod.stripTrailingSlash(targetURL);
        HttpPost filePost = new HttpPost(targetURL);
        filePost.setHeader("Accept", (Object)"application/json");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("*@TypeHint", "nt:file");
        builder.addBinaryBody("*", file, ContentType.create((String)context.getMimeType()), file.getName());
        filePost.setEntity(builder.build());
        String response = (String)context.getHttpClient().execute((ClassicHttpRequest)filePost, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
        context.getLog().debug((CharSequence)("Received response: " + response));
    }

    @Override
    public void undeploy(URI targetURL, String bundleName, DeployContext context) throws IOException {
        HttpPost post = new HttpPost(SlingPostDeployMethod.getURLWithFilename(targetURL, bundleName));
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        post.setHeader("Accept", (Object)"application/json");
        params.add(new BasicNameValuePair(":operation", "delete"));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        String response = (String)context.getHttpClient().execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
        context.getLog().debug((CharSequence)("Received response: " + response));
    }

    static URI getURLWithFilename(URI targetURL, String fileName) {
        return targetURL.resolve(fileName);
    }

    static URI stripTrailingSlash(URI targetURL) {
        if (targetURL.getPath().endsWith("/")) {
            String path = targetURL.getPath().substring(0, targetURL.getPath().length() - 1);
            try {
                return new URI(targetURL.getScheme(), targetURL.getUserInfo(), targetURL.getHost(), targetURL.getPort(), path, targetURL.getQuery(), targetURL.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Could not create new URI from existing one", e);
            }
        }
        return targetURL;
    }
}

