/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.jackrabbit.oak.commons.jmx.JmxUtil;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhiteboardUtils {
    public static final String JMX_OAK_DOMAIN = "org.apache.jackrabbit.oak";

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, long delayInSeconds) {
        return WhiteboardUtils.scheduleWithFixedDelay(whiteboard, runnable, delayInSeconds, false, false);
    }

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, long delayInSeconds, boolean runOnSingleClusterNode, boolean useDedicatedPool) {
        return WhiteboardUtils.scheduleWithFixedDelay(whiteboard, runnable, Collections.emptyMap(), delayInSeconds, runOnSingleClusterNode, useDedicatedPool);
    }

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, Map<String, Object> extraProps, long delayInSeconds, boolean runOnSingleClusterNode, boolean useDedicatedPool) {
        return WhiteboardUtils.scheduleWithFixedDelay(whiteboard, runnable, extraProps, delayInSeconds, runOnSingleClusterNode ? ScheduleExecutionInstanceTypes.RUN_ON_SINGLE : ScheduleExecutionInstanceTypes.DEFAULT, useDedicatedPool);
    }

    public static Registration scheduleWithFixedDelay(Whiteboard whiteboard, Runnable runnable, Map<String, Object> extraProps, long delayInSeconds, ScheduleExecutionInstanceTypes scheduleExecutionInstanceTypes, boolean useDedicatedPool) {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.putAll(extraProps);
        builder.put("scheduler.period", delayInSeconds);
        builder.put("scheduler.concurrent", false);
        if (scheduleExecutionInstanceTypes == ScheduleExecutionInstanceTypes.RUN_ON_SINGLE) {
            builder.put("scheduler.runOn", "SINGLE");
        } else if (scheduleExecutionInstanceTypes == ScheduleExecutionInstanceTypes.RUN_ON_LEADER) {
            builder.put("scheduler.runOn", "LEADER");
        }
        if (useDedicatedPool) {
            builder.put("scheduler.threadPool", "oak");
        }
        return whiteboard.register(Runnable.class, runnable, Collections.unmodifiableMap(builder));
    }

    public static <T> Registration registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name) {
        return WhiteboardUtils.registerMBean(whiteboard, iface, bean, type, name, Collections.emptyMap());
    }

    public static <T> Registration registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name, Map<String, String> attrs) {
        try {
            Hashtable<String, String> table = new Hashtable<String, String>(attrs);
            table.put("type", JmxUtil.quoteValueIfRequired(type));
            table.put("name", JmxUtil.quoteValueIfRequired(name));
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("jmx.objectname", new ObjectName(JMX_OAK_DOMAIN, table));
            properties.putAll(attrs);
            return whiteboard.register(iface, bean, Collections.unmodifiableMap(properties));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public static <T> List<T> getServices(@NotNull Whiteboard wb, @NotNull Class<T> type) {
        return WhiteboardUtils.getServices(wb, type, null);
    }

    @Nullable
    public static <T> T getService(@NotNull Whiteboard wb, @NotNull Class<T> type) {
        return WhiteboardUtils.getService(wb, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T> List<T> getServices(@NotNull Whiteboard wb, @NotNull Class<T> type, @Nullable Predicate<T> predicate) {
        Tracker<T> tracker = wb.track(type);
        try {
            if (predicate == null) {
                List<T> list = tracker.getServices();
                return list;
            }
            List list = tracker.getServices().stream().filter(predicate).collect(Collectors.toUnmodifiableList());
            return list;
        }
        finally {
            tracker.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T getService(@NotNull Whiteboard wb, @NotNull Class<T> type, @Nullable Predicate<T> predicate) {
        Tracker<T> tracker = wb.track(type);
        try {
            for (T service : tracker.getServices()) {
                if (predicate != null && !predicate.test(service)) continue;
                T t = service;
                return t;
            }
            Iterator<T> iterator = null;
            return (T)iterator;
        }
        finally {
            tracker.stop();
        }
    }

    public static enum ScheduleExecutionInstanceTypes {
        DEFAULT,
        RUN_ON_SINGLE,
        RUN_ON_LEADER;

    }
}

