/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.commons.jmx.ManagementOperation;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionGC
implements RevisionGCMBean {
    private static final Logger log = LoggerFactory.getLogger(RevisionGC.class);
    public static final String OP_NAME = "Revision garbage collection";
    @NotNull
    private ManagementOperation<Void> gcOp = ManagementOperation.done("Revision garbage collection", null);
    @NotNull
    private final Runnable runGC;
    @NotNull
    private final Runnable cancelGC;
    @NotNull
    private final Supplier<String> statusMessage;
    @NotNull
    private final Executor executor;

    public RevisionGC(@NotNull Runnable runGC, @NotNull Runnable cancelGC, @NotNull Supplier<String> statusMessage, @NotNull Executor executor) {
        this.runGC = Objects.requireNonNull(runGC);
        this.cancelGC = Objects.requireNonNull(cancelGC);
        this.statusMessage = Objects.requireNonNull(statusMessage);
        this.executor = Objects.requireNonNull(executor);
    }

    public RevisionGC(@NotNull Runnable runGC, @NotNull Runnable cancelGC, @NotNull Executor executor) {
        this(runGC, cancelGC, () -> "", executor);
    }

    @Override
    @NotNull
    public CompositeData startRevisionGC() {
        if (this.gcOp.isDone()) {
            this.gcOp = ManagementOperation.newManagementOperation(OP_NAME, this.statusMessage, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RevisionGC.this.runGC.run();
                    return null;
                }
            });
            this.executor.execute(this.gcOp);
            return ManagementOperation.Status.initiated(this.gcOp, "Revision garbage collection started").toCompositeData();
        }
        return ManagementOperation.Status.failed("Revision garbage collection already running").toCompositeData();
    }

    @Override
    @NotNull
    public CompositeData cancelRevisionGC() {
        if (!this.gcOp.isDone()) {
            this.executor.execute(ManagementOperation.newManagementOperation(OP_NAME, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RevisionGC.this.gcOp.cancel(false);
                    RevisionGC.this.cancelGC.run();
                    return null;
                }
            }));
            return ManagementOperation.Status.initiated(this.gcOp, "Revision garbage collection cancelled").toCompositeData();
        }
        return ManagementOperation.Status.failed("Revision garbage collection not running").toCompositeData();
    }

    @Override
    @NotNull
    public CompositeData getRevisionGCStatus() {
        return this.gcOp.getStatus().toCompositeData();
    }
}

