/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import org.apache.jackrabbit.oak.commons.collections.HashUtils;

public class BloomFilter {
    private final int k;
    private final int arraySize;
    private final long[] data;

    private BloomFilter(long[] data, int k) {
        this.data = data;
        this.k = k;
        this.arraySize = data.length;
    }

    public static BloomFilter construct(long n, double fpp) {
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        if (fpp <= 0.0 || fpp >= 1.0) {
            throw new IllegalArgumentException("fpp must be between 0 and 1");
        }
        long m = BloomFilter.calculateBits(n, fpp);
        int k = BloomFilter.calculateK((double)m / (double)n);
        return new BloomFilter(new long[(int)((m + 63L) / 64L)], k);
    }

    public static int calculateK(double bitsPerKey) {
        return Math.max(1, (int)Math.round(bitsPerKey * Math.log(2.0)));
    }

    public static long calculateBits(long n, double fpp) {
        return (long)Math.ceil((double)n * Math.log(fpp) / Math.log(1.0 / Math.pow(2.0, Math.log(2.0))));
    }

    public static long calculateN(long bits, double fpp) {
        return (long)Math.ceil((double)bits * Math.log(Math.pow(0.5, Math.log(2.0))) / Math.log(fpp));
    }

    public static double calculateFpp(long n, long bits, int k) {
        return Math.pow(1.0 - Math.exp((double)(-k) / ((double)bits / (double)n)), k);
    }

    public void add(String value) {
        this.add(HashUtils.hash64(value));
    }

    public void add(long hash) {
        long a = hash >>> 32 | hash << 32;
        long b = hash;
        for (int i = 0; i < this.k; ++i) {
            int n = HashUtils.reduce((int)(a >>> 32), this.arraySize);
            this.data[n] = this.data[n] | 1L << (int)a;
            a += b;
        }
    }

    public boolean mayContain(String value) {
        return this.mayContain(HashUtils.hash64(value));
    }

    public boolean mayContain(long hash) {
        long a = hash >>> 32 | hash << 32;
        long b = hash;
        for (int i = 0; i < this.k; ++i) {
            if ((this.data[HashUtils.reduce((int)(a >>> 32), this.arraySize)] & 1L << (int)a) == 0L) {
                return false;
            }
            a += b;
        }
        return true;
    }

    public long getBitCount() {
        return (long)this.data.length * 64L;
    }

    public int getK() {
        return this.k;
    }

    public long getEstimatedEntryCount() {
        long x = 0L;
        for (long d : this.data) {
            x += (long)Long.bitCount(d);
        }
        double m = this.getBitCount();
        return (long)(-(m / (double)this.k) * Math.log(1.0 - (double)x / m));
    }
}

