/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.oak.query.RuntimeNodeTraversalException;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterIterators {
    private static final Logger LOG = LoggerFactory.getLogger(FilterIterators.class);

    private FilterIterators() {
    }

    public static void checkMemoryLimit(long count, QueryLimits settings) {
        long maxMemoryEntries = settings.getLimitInMemory();
        if (count > maxMemoryEntries) {
            String message = "The query read more than " + maxMemoryEntries + " nodes in memory.";
            UnsupportedOperationException e = new UnsupportedOperationException(message + " To avoid running out of memory, processing was stopped.");
            LOG.warn(message, (Throwable)e);
            throw e;
        }
    }

    public static void checkReadLimit(long count, QueryLimits settings) {
        long maxReadEntries = settings.getLimitReads();
        if (count > maxReadEntries) {
            String message = "The query read or traversed more than " + maxReadEntries + " nodes.";
            RuntimeNodeTraversalException e = new RuntimeNodeTraversalException(message + " To avoid affecting other tasks, processing was stopped.");
            LOG.warn(message, (Throwable)e);
            throw e;
        }
    }

    public static <K> Iterator<K> newCombinedFilter(Iterator<K> it, boolean distinct, long limit, long offset, Comparator<K> orderBy, QueryLimits settings) {
        if (distinct) {
            it = FilterIterators.newDistinct(it, settings);
        }
        if (orderBy != null) {
            int max = (int)Math.min(Integer.MAX_VALUE, Math.min(Integer.MAX_VALUE, offset) + Math.min(Integer.MAX_VALUE, limit));
            it = FilterIterators.newSort(it, orderBy, max, settings);
        }
        if (offset != 0L) {
            it = FilterIterators.newOffset(it, offset);
        }
        if (limit < Long.MAX_VALUE) {
            it = FilterIterators.newLimit(it, limit);
        }
        return it;
    }

    public static <K> DistinctIterator<K> newDistinct(Iterator<K> it, QueryLimits settings) {
        return new DistinctIterator<K>(it, settings);
    }

    public static <K> Iterator<K> newLimit(Iterator<K> it, long limit) {
        return new LimitIterator<K>(it, limit);
    }

    public static <K> Iterator<K> newOffset(Iterator<K> it, long offset) {
        return new OffsetIterator<K>(it, offset);
    }

    public static <K> Iterator<K> newSort(Iterator<K> it, Comparator<K> orderBy, int max, QueryLimits settings) {
        return new SortIterator<K>(it, orderBy, max, settings);
    }

    static class LimitIterator<K>
    implements Iterator<K> {
        private final Iterator<K> source;
        private final long limit;
        private long count;

        LimitIterator(Iterator<K> source, long limit) {
            this.source = source;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.limit && this.source.hasNext();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            return this.source.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class OffsetIterator<K>
    implements Iterator<K> {
        private final Iterator<K> source;
        private final long offset;
        private boolean init;

        OffsetIterator(Iterator<K> source, long offset) {
            this.source = source;
            this.offset = offset;
        }

        private void init() {
            if (this.init) {
                return;
            }
            this.init = true;
            int i = 0;
            while ((long)i < this.offset && this.source.hasNext()) {
                this.source.next();
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            this.init();
            return this.source.hasNext();
        }

        @Override
        public K next() {
            this.init();
            return this.source.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class SortIterator<K>
    implements Iterator<K> {
        private final Iterator<K> source;
        private final QueryLimits settings;
        private final Comparator<K> orderBy;
        private Iterator<K> result;
        private final int max;

        SortIterator(Iterator<K> source, Comparator<K> orderBy, int max, QueryLimits settings) {
            this.source = source;
            this.orderBy = orderBy;
            this.max = max;
            this.settings = settings;
        }

        private void init() {
            if (this.result != null) {
                return;
            }
            ArrayList<K> list = new ArrayList<K>();
            while (this.source.hasNext()) {
                K x = this.source.next();
                list.add(x);
                FilterIterators.checkMemoryLimit(list.size(), this.settings);
                if ((long)list.size() <= (long)this.max * 2L) continue;
                Collections.sort(list, this.orderBy);
                SortIterator.keepFirst(list, this.max);
            }
            Collections.sort(list, this.orderBy);
            SortIterator.keepFirst(list, this.max);
            this.result = list.iterator();
        }

        private static <K> void keepFirst(ArrayList<K> list, int keep) {
            while (list.size() > keep) {
                list.remove(list.size() - 1);
            }
        }

        @Override
        public boolean hasNext() {
            this.init();
            return this.result.hasNext();
        }

        @Override
        public K next() {
            this.init();
            return this.result.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class DistinctIterator<K>
    implements Iterator<K> {
        private final Iterator<K> source;
        private final QueryLimits settings;
        private final HashSet<K> distinctSet;
        private K current;
        private boolean end;

        DistinctIterator(Iterator<K> source, QueryLimits settings) {
            this.source = source;
            this.settings = settings;
            this.distinctSet = new HashSet();
        }

        private void fetchNext() {
            if (this.end) {
                return;
            }
            while (this.source.hasNext()) {
                this.current = this.source.next();
                if (!this.distinctSet.add(this.current)) continue;
                FilterIterators.checkMemoryLimit(this.distinctSet.size(), this.settings);
                return;
            }
            this.current = null;
            this.end = true;
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.fetchNext();
            }
            return !this.end;
        }

        @Override
        public K next() {
            if (this.end) {
                throw new NoSuchElementException();
            }
            if (this.current == null) {
                this.fetchNext();
            }
            K r = this.current;
            this.current = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

