/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import org.apache.sling.testing.mock.osgi.MockLogService;
import org.junit.Before;
import org.junit.Test;
import org.osgi.service.log.LogService;

public class MockLogServiceTest {
    private LogService logService;

    @Before
    public void setUp() throws Exception {
        this.logService = new MockLogService(this.getClass());
    }

    @Test
    public void testLog() {
        this.logService.log(1, "message 1");
        this.logService.log(2, "message 1");
        this.logService.log(3, "message 1");
        this.logService.log(4, "message 1");
        this.logService.log(null, 1, "message 1");
        this.logService.log(null, 2, "message 1");
        this.logService.log(null, 3, "message 1");
        this.logService.log(null, 4, "message 1");
    }

    @Test
    public void testLogException() {
        this.logService.log(1, "message 2", (Throwable)new Exception());
        this.logService.log(2, "message 2", (Throwable)new Exception());
        this.logService.log(3, "message 2", (Throwable)new Exception());
        this.logService.log(4, "message 2", (Throwable)new Exception());
        this.logService.log(null, 1, "message 2", (Throwable)new Exception());
        this.logService.log(null, 2, "message 2", (Throwable)new Exception());
        this.logService.log(null, 3, "message 2", (Throwable)new Exception());
        this.logService.log(null, 4, "message 2", (Throwable)new Exception());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLogInvalidLevel() {
        this.logService.log(0, "message 1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLogExceptionInvalidLevel() {
        this.logService.log(0, "message 2", (Throwable)new Exception());
    }
}

