/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.superimposing.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.superimposing.SuperimposingResourceProvider;
import org.apache.sling.superimposing.impl.SuperimposingResource;
import org.apache.sling.superimposing.impl.SuperimposingResourceIterator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperimposingResourceProviderImpl
implements SuperimposingResourceProvider {
    private static final Logger log = LoggerFactory.getLogger(SuperimposingResourceProviderImpl.class);
    private final String rootPath;
    private final String rootPrefix;
    private final String sourcePath;
    private final String sourcePathPrefix;
    private final boolean overlayable;
    private final String toString;
    private ServiceRegistration registration;

    SuperimposingResourceProviderImpl(String rootPath, String sourcePath, boolean overlayable) {
        this.rootPath = rootPath;
        this.rootPrefix = rootPath.concat("/");
        this.sourcePath = sourcePath;
        this.sourcePathPrefix = sourcePath.concat("/");
        this.overlayable = overlayable;
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" [path=").append(rootPath).append(", ");
        sb.append("sourcePath=").append(sourcePath).append(", ");
        sb.append("overlayable=").append(overlayable).append("]");
        this.toString = sb.toString();
    }

    public Resource getResource(ResourceResolver resolver, HttpServletRequest httpServletRequest, String path) {
        return this.getResource(resolver, path);
    }

    public Resource getResource(ResourceResolver resolver, String path) {
        Resource mappedResource;
        String mappedPath = SuperimposingResourceProviderImpl.mapPath(this, resolver, path);
        if (null != mappedPath && null != (mappedResource = resolver.getResource(mappedPath))) {
            return new SuperimposingResource(mappedResource, path);
        }
        return null;
    }

    public Iterator<Resource> listChildren(Resource resource) {
        Resource currentResource = resource instanceof ResourceWrapper ? ((ResourceWrapper)resource).getResource() : resource;
        if (currentResource instanceof SuperimposingResource) {
            SuperimposingResource res = (SuperimposingResource)currentResource;
            ResourceResolver resolver = res.getResource().getResourceResolver();
            Iterator children = resolver.listChildren(res.getResource());
            return new SuperimposingResourceIterator(this, children);
        }
        return null;
    }

    static String mapPath(SuperimposingResourceProviderImpl provider, ResourceResolver resolver, String path) {
        if (provider.overlayable) {
            return SuperimposingResourceProviderImpl.mapPathWithOverlay(provider, resolver, path);
        }
        return SuperimposingResourceProviderImpl.mapPathWithoutOverlay(provider, resolver, path);
    }

    static String mapPathWithOverlay(SuperimposingResourceProviderImpl provider, ResourceResolver resolver, String path) {
        if (StringUtils.equals((String)path, (String)provider.rootPath)) {
            return SuperimposingResourceProviderImpl.mapPathWithoutOverlay(provider, resolver, path);
        }
        if (StringUtils.startsWith((String)path, (String)provider.rootPrefix)) {
            if (SuperimposingResourceProviderImpl.hasOverlayResource(resolver, path)) {
                return null;
            }
            return SuperimposingResourceProviderImpl.mapPathWithoutOverlay(provider, resolver, path);
        }
        return null;
    }

    static boolean hasOverlayResource(ResourceResolver resolver, String path) {
        Session session = (Session)resolver.adaptTo(Session.class);
        try {
            return null != session && session.itemExists(path);
        }
        catch (RepositoryException e) {
            log.error("Error accessing the repository. ", (Throwable)e);
            return false;
        }
    }

    static String mapPathWithoutOverlay(SuperimposingResourceProviderImpl provider, ResourceResolver resolver, String path) {
        String mappedPath = StringUtils.equals((String)path, (String)provider.rootPath) ? provider.sourcePath : (StringUtils.startsWith((String)path, (String)provider.rootPrefix) ? StringUtils.replaceOnce((String)path, (String)provider.rootPrefix, (String)provider.sourcePathPrefix) : null);
        return mappedPath;
    }

    static String reverseMapPath(SuperimposingResourceProviderImpl provider, String path) {
        String mappedPath = path.startsWith(provider.sourcePathPrefix) ? StringUtils.replaceOnce((String)path, (String)provider.sourcePathPrefix, (String)provider.rootPrefix) : (path.equals(provider.sourcePath) ? provider.rootPath : null);
        return mappedPath;
    }

    void registerService(BundleContext context) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.description", "Provider of superimposed resources");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("provider.roots", new String[]{this.rootPath});
        this.registration = context.registerService(SERVICE_NAME, (Object)this, props);
        log.info("Registered {}", (Object)this);
    }

    void unregisterService() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
            log.info("Unregistered {}", (Object)this);
        }
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public boolean isOverlayable() {
        return this.overlayable;
    }

    public boolean equals(Object o) {
        if (o instanceof SuperimposingResourceProviderImpl) {
            SuperimposingResourceProviderImpl srp = (SuperimposingResourceProviderImpl)o;
            return this.rootPath.equals(srp.rootPath) && this.sourcePath.equals(srp.sourcePath) && this.overlayable == srp.overlayable;
        }
        return false;
    }

    public String toString() {
        return this.toString;
    }
}

