/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.async;

import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.UnaryCallback;
import org.apache.sling.scripting.sightly.js.impl.loop.EventLoopInterop;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class AsyncExtractor {
    public static final String THEN_METHOD = "then";

    public void extract(Object jsObj, UnaryCallback unaryCallback) {
        if (!this.isPromise(jsObj)) {
            unaryCallback.invoke(jsObj);
        }
        if (jsObj instanceof AsyncContainer) {
            ((AsyncContainer)jsObj).addListener(unaryCallback);
        }
        if (jsObj instanceof ScriptableObject) {
            ScriptableObject scriptableObject = (ScriptableObject)jsObj;
            this.decodeJSPromise((Scriptable)scriptableObject, unaryCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeJSPromise(final Scriptable promise, UnaryCallback callback) {
        try {
            Context context = Context.enter();
            AsyncContainer errorContainer = new AsyncContainer();
            final Function errorHandler = this.createErrorHandler(errorContainer);
            final Function successHandler = AsyncExtractor.convertCallback(callback);
            EventLoopInterop.schedule(context, new Runnable(){

                @Override
                public void run() {
                    ScriptableObject.callMethod((Scriptable)promise, (String)AsyncExtractor.THEN_METHOD, (Object[])new Object[]{successHandler, errorHandler});
                }
            });
            if (errorContainer.isCompleted()) {
                throw new SightlyException("Promise has completed with failure: " + Context.toString((Object)errorContainer.getResult()));
            }
        }
        finally {
            Context.exit();
        }
    }

    private Function createErrorHandler(AsyncContainer asyncContainer) {
        return AsyncExtractor.convertCallback(asyncContainer.createCompletionCallback());
    }

    public boolean isPromise(Object jsObj) {
        if (jsObj instanceof AsyncContainer) {
            return true;
        }
        if (jsObj instanceof ScriptableObject) {
            Scriptable scriptable = (Scriptable)jsObj;
            return ScriptableObject.hasProperty((Scriptable)scriptable, (String)THEN_METHOD);
        }
        return false;
    }

    private static Function convertCallback(final UnaryCallback unaryCallback) {
        return new BaseFunction(){

            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                Object arg = args.length == 0 ? Context.getUndefinedValue() : args[0];
                unaryCallback.invoke(arg);
                return Context.getUndefinedValue();
            }
        };
    }
}

