/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.async;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.scripting.sightly.js.impl.async.UnaryCallback;

public class AsyncContainer {
    private Object value;
    private boolean completed;
    private List<UnaryCallback> callbacks = new ArrayList<UnaryCallback>();

    public void addListener(UnaryCallback unaryCallback) {
        this.callbacks.add(unaryCallback);
        if (this.completed) {
            this.notifyListener(unaryCallback);
        }
    }

    public Object getResult() {
        return this.value;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void complete(Object value) {
        if (this.completed) {
            throw new IllegalStateException("Value was already completed");
        }
        this.completed = true;
        this.value = value;
        for (UnaryCallback callback : this.callbacks) {
            this.notifyListener(callback);
        }
    }

    public UnaryCallback createCompletionCallback() {
        return new UnaryCallback(){

            @Override
            public void invoke(Object arg) {
                AsyncContainer.this.complete(arg);
            }
        };
    }

    private void notifyListener(UnaryCallback unaryCallback) {
        unaryCallback.invoke(this.value);
    }
}

