/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Atom;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class TestPlugin
extends AbstractPlugin {
    public TestPlugin() {
        this.name = "test";
        this.priority = 1;
    }

    @Override
    public PluginInvoke invoke(final Expression expressionNode, final PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private boolean globalBinding;

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                boolean constantValueComparison;
                String variableName = TestPlugin.this.decodeVariableName(callInfo);
                ExpressionNode root = expressionNode.getRoot();
                boolean bl = constantValueComparison = root instanceof Atom && !(root instanceof Identifier) || root instanceof NullLiteral || root instanceof ArrayLiteral || root instanceof MapLiteral;
                if (!constantValueComparison && root instanceof BinaryOperation) {
                    boolean bl2 = constantValueComparison = ((BinaryOperation)root).getOperator() == BinaryOperator.CONCATENATE;
                }
                if (constantValueComparison) {
                    stream.warn(new PushStream.StreamMessage("data-sly-test: redundant constant value comparison", expressionNode.getRawText()));
                }
                boolean bl3 = this.globalBinding = variableName != null;
                if (variableName == null) {
                    variableName = compilerContext.generateVariable("testVariable");
                }
                if (this.globalBinding) {
                    stream.write(new VariableBinding.Global(variableName, root));
                } else {
                    stream.write(new VariableBinding.Start(variableName, root));
                }
                stream.write(new Conditional.Start(variableName, true));
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(Conditional.END);
                if (!this.globalBinding) {
                    stream.write(VariableBinding.END);
                }
            }
        };
    }
}

