/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.frontend;

import org.apache.sling.scripting.sightly.compiler.expression.Expression;

public interface Fragment {
    public boolean isString();

    public boolean isExpression();

    public Expression getExpression();

    public String getText();

    public static class Text
    implements Fragment {
        private String text;

        public Text(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public Expression getExpression() {
            throw new UnsupportedOperationException("Not an expression fragment");
        }

        public String toString() {
            return "Text{text='" + this.text + '\'' + '}';
        }
    }

    public static class Expr
    implements Fragment {
        private Expression expression;

        public Expr(Expression expression) {
            this.expression = expression;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException("Not a text fragment");
        }

        @Override
        public boolean isString() {
            return false;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        public String toString() {
            return "Expr{expression=" + this.expression + '}';
        }
    }
}

