/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.expression.nodes;

import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;

public final class PropertyAccess
implements ExpressionNode {
    private final ExpressionNode target;
    private final ExpressionNode property;

    public PropertyAccess(ExpressionNode target, ExpressionNode property) {
        this.target = target;
        this.property = property;
    }

    public PropertyAccess(ExpressionNode target, String property) {
        this.target = target;
        this.property = new StringConstant(property);
    }

    public PropertyAccess(ExpressionNode target, Iterable<String> properties) {
        String lastProp = null;
        ExpressionNode result = target;
        for (String property : properties) {
            if (lastProp != null) {
                result = new PropertyAccess(result, new StringConstant(lastProp));
            }
            lastProp = property;
        }
        if (lastProp == null) {
            throw new IllegalArgumentException("The list of properties must be non-empty");
        }
        this.target = result;
        this.property = new StringConstant(lastProp);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.evaluate(this);
    }

    public ExpressionNode getTarget() {
        return this.target;
    }

    public ExpressionNode getProperty() {
        return this.property;
    }

    public String toString() {
        return "PropertyAccess{target=" + this.target + ", property='" + this.property + '\'' + '}';
    }
}

