/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParentsTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(GetParentsTag.class);
    private static final long serialVersionUID = -7519905660523764503L;
    private transient Resource resource;
    private String startDepth = "0";
    private String var;

    public int doEndTag() {
        Resource parent;
        log.trace("doEndTag");
        List parents = new ArrayList<Resource>();
        Resource current = this.resource;
        while ((parent = current.getParent()) != null) {
            parents.add(parent);
            current = parent;
        }
        Collections.reverse(parents);
        int depth = Integer.parseInt(this.startDepth, 10);
        if (depth <= parents.size()) {
            parents = parents.subList(depth, parents.size());
        } else {
            parents.clear();
        }
        log.debug("Saving {} to variable {}", parents, (Object)this.var);
        this.pageContext.setAttribute(this.var, parents.iterator());
        return 6;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getStartDepth() {
        return this.startDepth;
    }

    public String getVar() {
        return this.var;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setStartDepth(String startDepth) {
        this.startDepth = startDepth;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

