/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.providertype.bndplugin;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.lib.json.Decoder;
import aQute.lib.json.JSONCodec;
import aQute.service.reporter.Reporter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ProviderTypeScanner
implements AnalyzerPlugin,
Plugin {
    private static final String API_INFO_JSON_RESOURCE_PATH = "META-INF/api-info.json";
    private static final String FIELD_PROVIDER_TYPES = "providerTypes";
    private static final String MESSAGE = "Type \"%s\" %s provider type \"%s\". This is not allowed!";
    private static final String ATTRIBUTE_IGNORED_PROVIDER_TYPES = "ignored";
    private Map<String, String> parameters = new HashMap<String, String>();

    public void setProperties(Map<String, String> map) throws Exception {
        this.parameters.clear();
        this.parameters.putAll(map);
    }

    public void setReporter(Reporter processor) {
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        List apiInfoJsonResources = analyzer.findResources(s -> s.equals(API_INFO_JSON_RESOURCE_PATH)).collect(Collectors.toList());
        if (apiInfoJsonResources.isEmpty()) {
            analyzer.warning("Could not find resource \"%s\" in the classpath", new Object[]{API_INFO_JSON_RESOURCE_PATH});
        } else {
            HashSet<String> providerTypes = new HashSet<String>();
            for (Resource apiInfoJsonResource : apiInfoJsonResources) {
                try {
                    Set<String> resourceProviderTypes = this.collectProviderTypes((Reporter)analyzer, apiInfoJsonResource);
                    analyzer.trace("Added provider types from resource \"%s\": %s", new Object[]{apiInfoJsonResource, String.join((CharSequence)",", resourceProviderTypes)});
                    providerTypes.addAll(resourceProviderTypes);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not parse JSON from resource " + apiInfoJsonResource, e);
                }
            }
            Arrays.stream(this.parameters.getOrDefault(ATTRIBUTE_IGNORED_PROVIDER_TYPES, "").split(",")).filter(s -> !s.isBlank()).forEach(ignored -> {
                if (providerTypes.remove(ignored)) {
                    analyzer.trace("Ignore extensions of provider type \"%s\" due to plugin configuration", new Object[]{ignored});
                } else {
                    analyzer.warning("Ignored class \"%s\" is not defined as provider type at all, you can safely remove the according plugin parameter", new Object[]{ignored});
                }
            });
            this.checkIfExtendingType((Reporter)analyzer, analyzer.getClassspace().values(), providerTypes);
        }
        return false;
    }

    private void checkIfExtendingType(Reporter reporter, Collection<Clazz> clazzes, Set<String> providerTypes) {
        for (Clazz clazz : clazzes) {
            if (clazz.getSuper() != null && providerTypes.contains(clazz.getSuper().getFQN())) {
                reporter.error(MESSAGE, new Object[]{clazz.getFQN(), "extends", clazz.getSuper().getFQN()}).file(clazz.getSourceFile());
            }
            for (Descriptors.TypeRef interfaceType : clazz.interfaces()) {
                if (!providerTypes.contains(interfaceType.getFQN())) continue;
                reporter.error(MESSAGE, new Object[]{clazz.getFQN(), "implements", interfaceType.getFQN()}).file(clazz.getSourceFile());
            }
        }
    }

    private Set<String> collectProviderTypes(Reporter reporter, Resource apiInfoResource) throws Exception {
        block15: {
            JSONCodec codec = new JSONCodec();
            try (InputStream input = apiInfoResource.openInputStream();
                 Decoder decoder = codec.dec().from(input);){
                Map jsonMap = (Map)decoder.get(Map.class);
                Object providerTypes = jsonMap.get(FIELD_PROVIDER_TYPES);
                if (providerTypes == null) {
                    reporter.error("Resource \"%s\" does not contain a field named \"%s\"", new Object[]{API_INFO_JSON_RESOURCE_PATH, FIELD_PROVIDER_TYPES});
                    break block15;
                }
                if (!(providerTypes instanceof Collection)) {
                    reporter.error("Field \"%s\" in JSON resource \"%s\" is not containing a string array but a type converted to %s", new Object[]{FIELD_PROVIDER_TYPES, API_INFO_JSON_RESOURCE_PATH, providerTypes.getClass().getName()});
                    break block15;
                }
                HashSet<String> hashSet = new HashSet<String>((Collection)providerTypes);
                return hashSet;
            }
        }
        return Collections.emptySet();
    }
}

