/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal.bindings;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.caconfig.spi.metadata.ConfigurationMetadata;

public class ConfigurationMap
implements Map<String, Object> {
    private final Resource resource;
    private final ConfigurationMetadataProvider configMetadataProvider;
    private Set<String> configNamesCache;
    private Map<String, Object> valuesCache = new HashMap<String, Object>();

    public ConfigurationMap(Resource resource, ConfigurationMetadataProvider provider) {
        this.resource = resource;
        this.configMetadataProvider = provider;
    }

    private Set<String> getConfigNames() {
        if (this.configNamesCache == null) {
            this.configNamesCache = this.configMetadataProvider.getConfigurationNames();
        }
        return this.configNamesCache;
    }

    @Override
    public int size() {
        return this.getConfigNames().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getConfigNames().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getConfigNames().contains(key);
    }

    @Override
    public Object get(Object key) {
        Object value = this.valuesCache.get(key);
        if (value == null && (value = this.getConfigValue((String)key)) != null) {
            this.valuesCache.put((String)key, value);
        }
        return value;
    }

    private Object getConfigValue(String configName) {
        ConfigurationBuilder configBuilder = ((ConfigurationBuilder)this.resource.adaptTo(ConfigurationBuilder.class)).name(configName);
        if (this.isCollection(configName)) {
            return configBuilder.asValueMapCollection();
        }
        return configBuilder.asValueMap();
    }

    private boolean isCollection(String configName) {
        ConfigurationMetadata configMetadata = this.configMetadataProvider.getConfigurationMetadata(configName);
        if (configMetadata != null) {
            return configMetadata.isCollection();
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        return this.getConfigNames();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

