/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.couchbase.resourceprovider.impl;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.query.dsl.Expression;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.nosql.couchbase.client.CouchbaseClient;
import org.apache.sling.nosql.couchbase.client.CouchbaseKey;
import org.apache.sling.nosql.generic.adapter.AbstractNoSqlAdapter;
import org.apache.sling.nosql.generic.adapter.MultiValueMode;
import org.apache.sling.nosql.generic.adapter.NoSqlData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseNoSqlAdapter
extends AbstractNoSqlAdapter {
    private static final String PN_PATH = "path";
    private static final String PN_PARENT_PATH = "parentPath";
    private static final String PN_DATA = "data";
    private final CouchbaseClient couchbaseClient;
    private final String cacheKeyPrefix;
    private static final N1qlParams N1QL_PARAMS = N1qlParams.build().consistency(ScanConsistency.REQUEST_PLUS);
    private static final Logger log = LoggerFactory.getLogger(CouchbaseNoSqlAdapter.class);

    public CouchbaseNoSqlAdapter(CouchbaseClient couchbaseClient, String cacheKeyPrefix) {
        this.couchbaseClient = couchbaseClient;
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public boolean validPath(String path) {
        return this.couchbaseClient != null && this.couchbaseClient.isEnabled();
    }

    public NoSqlData get(String path) {
        String cacheKey;
        Bucket bucket = this.couchbaseClient.getBucket();
        JsonDocument doc = bucket.get(cacheKey = CouchbaseKey.build((String)path, (String)this.cacheKeyPrefix));
        if (doc == null) {
            return null;
        }
        JsonObject data = ((JsonObject)doc.content()).getObject(PN_DATA);
        if (data == null) {
            return null;
        }
        return new NoSqlData(path, data.toMap(), MultiValueMode.LISTS);
    }

    public Iterator<NoSqlData> getChildren(String parentPath) {
        Bucket bucket = this.couchbaseClient.getBucket();
        SimpleN1qlQuery query = N1qlQuery.simple((Statement)Select.select((String[])new String[]{"*"}).from(this.couchbaseClient.getBucketName()).where(Expression.x((String)PN_PARENT_PATH).eq(Expression.s((String[])new String[]{parentPath}))), (N1qlParams)N1QL_PARAMS);
        N1qlQueryResult queryResult = bucket.query((N1qlQuery)query);
        this.handleQueryError(queryResult);
        final Iterator results = queryResult.iterator();
        return new Iterator<NoSqlData>(){

            @Override
            public boolean hasNext() {
                return results.hasNext();
            }

            @Override
            public NoSqlData next() {
                JsonObject item = ((N1qlQueryRow)results.next()).value();
                JsonObject envelope = item.getObject(CouchbaseNoSqlAdapter.this.couchbaseClient.getBucketName());
                String path = envelope.getString(CouchbaseNoSqlAdapter.PN_PATH);
                JsonObject data = envelope.getObject(CouchbaseNoSqlAdapter.PN_DATA);
                return new NoSqlData(path, data.toMap(), MultiValueMode.LISTS);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean store(NoSqlData data) {
        Bucket bucket = this.couchbaseClient.getBucket();
        String cacheKey = CouchbaseKey.build((String)data.getPath(), (String)this.cacheKeyPrefix);
        JsonObject envelope = JsonObject.create();
        envelope.put(PN_PATH, data.getPath());
        envelope.put(PN_DATA, JsonObject.from((Map)data.getProperties(MultiValueMode.LISTS)));
        String parentPath = ResourceUtil.getParent((String)data.getPath());
        if (parentPath != null) {
            envelope.put(PN_PARENT_PATH, parentPath);
        }
        JsonDocument doc = JsonDocument.create((String)cacheKey, (JsonObject)envelope);
        try {
            bucket.insert((Document)doc);
            return true;
        }
        catch (DocumentAlreadyExistsException ex) {
            bucket.upsert((Document)doc);
            return false;
        }
    }

    public boolean deleteRecursive(String path) {
        Bucket bucket = this.couchbaseClient.getBucket();
        Pattern descendantsAndSelf = Pattern.compile("^" + path + "(/.+)?$");
        SimpleN1qlQuery query = N1qlQuery.simple((Statement)Select.select((String[])new String[]{"*"}).from(this.couchbaseClient.getBucketName()).where("REGEXP_LIKE(`path`, '" + descendantsAndSelf.pattern() + "')"), (N1qlParams)N1QL_PARAMS);
        N1qlQueryResult queryResult = bucket.query((N1qlQuery)query);
        this.handleQueryError(queryResult);
        Iterator results = queryResult.iterator();
        boolean deletedAny = false;
        while (results.hasNext()) {
            JsonObject item = ((N1qlQueryRow)results.next()).value();
            JsonObject envelope = item.getObject(this.couchbaseClient.getBucketName());
            String itemPath = envelope.getString(PN_PATH);
            String itemCacheKey = CouchbaseKey.build((String)itemPath, (String)this.cacheKeyPrefix);
            bucket.remove(itemCacheKey);
            deletedAny = true;
        }
        return deletedAny;
    }

    private void handleQueryError(N1qlQueryResult queryResult) {
        if (!queryResult.parseSuccess()) {
            throw new RuntimeException("Couchbase query parsing error: " + StringUtils.join((Iterable)queryResult.errors(), (String)"\n"));
        }
        if (!queryResult.finalSuccess()) {
            throw new RuntimeException("Couchbase query error: " + StringUtils.join((Iterable)queryResult.errors(), (String)"\n"));
        }
    }

    public void checkConnection() throws LoginException {
        try {
            Bucket bucket = this.couchbaseClient.getBucket();
            String cacheKey = CouchbaseKey.build((String)"/", (String)this.cacheKeyPrefix);
            bucket.exists(cacheKey);
        }
        catch (Throwable ex) {
            throw new LoginException(ex);
        }
    }

    public void createIndexDefinitions() {
        try {
            Bucket bucket = this.couchbaseClient.getBucket();
            bucket.query((N1qlQuery)N1qlQuery.simple((String)("CREATE PRIMARY INDEX ON `" + this.couchbaseClient.getBucketName() + "`")));
            bucket.query((N1qlQuery)N1qlQuery.simple((String)("CREATE INDEX parentPath ON `" + this.couchbaseClient.getBucketName() + "`(" + PN_PARENT_PATH + ")")));
        }
        catch (Throwable ex) {
            log.debug("Unable to create/validate couchbase index definitions: " + ex.getMessage(), ex);
        }
    }
}

