/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;

public class MBeanStartupListener
implements StartupListener {
    private static final String NAME_LAUNCHER = "org.apache.sling.launchpad:type=Launcher";
    private final MBeanServer jmxServer;
    private final ObjectName launcherName = new ObjectName("org.apache.sling.launchpad:type=Launcher");
    private boolean available;

    public MBeanStartupListener() throws MalformedObjectNameException {
        this.jmxServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.jmxServer.getMBeanInfo(this.launcherName);
            this.available = true;
        }
        catch (Exception ignore) {
            this.available = false;
        }
    }

    @Override
    public void inform(StartupMode mode, boolean finished) {
    }

    @Override
    public void startupFinished(StartupMode mode) {
        if (this.available) {
            try {
                this.jmxServer.invoke(this.launcherName, "startupFinished", null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void startupProgress(float ratio) {
        if (this.available) {
            try {
                this.jmxServer.invoke(this.launcherName, "startupProgress", new Object[]{Float.valueOf(ratio)}, new String[]{Float.class.getName()});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

