/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.healthcheck.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.TestSelector;
import org.apache.sling.junit.TestsManager;
import org.apache.sling.junit.healthcheck.impl.JUnitTestSelector;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(name="hc.name"), @Property(name="hc.tags", unbounded=PropertyUnbounded.ARRAY), @Property(name="hc.mbean.name")})
@Service(value={HealthCheck.class})
public class JUnitHealthCheck
implements HealthCheck {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private TestsManager testsManager;
    @Property
    public static final String TEST_PACKAGE_OR_CLASS_PROP = "test.package.or.class";
    private TestSelector testSelector;
    @Property
    public static final String TEST_METHOD = "test.method";

    @Activate
    public void activate(Map<String, Object> properties) {
        String extension = "json";
        Object o = properties.get(TEST_METHOD);
        String testMethod = o == null ? "" : o.toString();
        this.testSelector = new JUnitTestSelector(String.valueOf(properties.get(TEST_PACKAGE_OR_CLASS_PROP)), testMethod, "json");
        this.log.info("Activated with TestSelector={}", (Object)this.testSelector);
    }

    public Result execute() {
        String extension = "json";
        FormattingResultLog resultLog = new FormattingResultLog();
        CustomRunListener listener = new CustomRunListener(resultLog);
        CustomRenderer r = new CustomRenderer(listener, "json", resultLog);
        Collection testNames = this.testsManager.getTestNames(this.testSelector);
        if (testNames.isEmpty()) {
            resultLog.warn("No tests found for selector {}", new Object[]{this.testSelector});
        } else {
            try {
                this.testsManager.executeTests(testNames, (Renderer)r, this.testSelector);
                if (listener.nTests == 0) {
                    resultLog.warn("No tests executed by {}", new Object[]{this.testSelector});
                }
            }
            catch (Exception e) {
                resultLog.warn("Exception while executing tests (" + this.testSelector + ")" + e, new Object[0]);
            }
        }
        return new Result((ResultLog)resultLog);
    }

    protected void bindTestsManager(TestsManager testsManager) {
        this.testsManager = testsManager;
    }

    protected void unbindTestsManager(TestsManager testsManager) {
        if (this.testsManager == testsManager) {
            this.testsManager = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomRenderer
    implements Renderer {
        private final String extension;
        private final RunListener listener;
        private final FormattingResultLog resultLog;

        CustomRenderer(RunListener listener, String extension, FormattingResultLog resultLog) {
            this.extension = extension;
            this.listener = listener;
            this.resultLog = resultLog;
        }

        public boolean appliesTo(TestSelector ts) {
            return true;
        }

        public void cleanup() {
        }

        public String getExtension() {
            return this.extension;
        }

        public RunListener getRunListener() {
            return this.listener;
        }

        public void info(String role, String info) {
            this.resultLog.info(info, new Object[0]);
        }

        public void link(String arg0, String arg1, String arg2) {
        }

        public void list(String arg0, Collection<String> arg1) {
        }

        public void setup(HttpServletResponse arg0, String arg1) throws IOException, UnsupportedEncodingException {
        }

        public void title(int arg0, String arg1) {
        }
    }

    private static class CustomRunListener
    extends RunListener {
        private final FormattingResultLog resultLog;
        int nTests;

        CustomRunListener(FormattingResultLog resultLog) {
            this.resultLog = resultLog;
        }

        public void testFailure(Failure failure) throws Exception {
            super.testFailure(failure);
            this.resultLog.warn(failure.getMessage(), new Object[0]);
        }

        public void testFinished(Description description) throws Exception {
            super.testFinished(description);
            this.resultLog.debug("Test finished: {}", new Object[]{description});
            ++this.nTests;
        }
    }
}

