/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.servlets;

import java.io.IOException;
import javax.jcr.Repository;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.webdav.impl.helper.SlingResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingSimpleWebDavServlet
extends SimpleWebdavServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SlingResourceConfig resourceConfig;
    private final Repository repository;

    SlingSimpleWebDavServlet(SlingResourceConfig resourceConfig, Repository repository) {
        this.resourceConfig = resourceConfig;
        this.repository = repository;
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.setResourceConfig(this.resourceConfig);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doService(request, response);
        }
        catch (RuntimeException re) {
            this.log.error("service: Uncaught RuntimeException", (Throwable)re);
            throw new ServletException("Uncaught RuntimeException: " + re);
        }
        catch (Error e) {
            this.log.error("service: Uncaught Error", (Throwable)e);
            throw new ServletException("Uncaught Error: " + e);
        }
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pinfo = request.getPathInfo();
        if (pinfo != null && pinfo.length() > 1) {
            super.service(request, response);
        } else if ("OPTIONS".equals(request.getMethod())) {
            response.setContentLength(0);
            response.setStatus(200);
            response.setHeader("Allow", "OPTIONS, GET, HEAD");
        } else {
            SlingRepository slingRepo = (SlingRepository)this.getRepository();
            if (slingRepo.getDefaultWorkspace() == null) {
                response.sendError(404, "JCR workspace name required, please add it to the end of the URL (for the Jackrabbit embedded repository the default name is 'default') ");
            } else {
                String uri = request.getRequestURI();
                if (pinfo == null) {
                    uri = uri + "/";
                }
                uri = uri + slingRepo.getDefaultWorkspace();
                response.sendRedirect(uri);
            }
        }
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }
}

