/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.sling.jcr.base.internal.mount.ProxySession;
import org.apache.sling.jcr.base.internal.mount.ProxyWrapper;

public class ProxyItem<T extends Item>
extends ProxyWrapper<T>
implements Item {
    public ProxyItem(ProxySession mountSession, T delegate) {
        super(mountSession, delegate);
    }

    public String getPath() throws RepositoryException {
        return ((Item)this.delegate).getPath();
    }

    public String getName() throws RepositoryException {
        return ((Item)this.delegate).getName();
    }

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.mountSession.getItem(((Item)this.delegate).getAncestor(depth).getPath());
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        String parentPath;
        try {
            parentPath = ((Item)this.delegate).getParent().getPath();
        }
        catch (Exception ex) {
            if (ex instanceof AccessDeniedException) {
                throw (AccessDeniedException)ex;
            }
            parentPath = PathUtils.getParentPath((String)((Item)this.delegate).getPath());
        }
        return this.mountSession.getNode(parentPath);
    }

    public int getDepth() throws RepositoryException {
        return ((Item)this.delegate).getDepth();
    }

    public Session getSession() throws RepositoryException {
        return this.mountSession;
    }

    public boolean isNode() {
        return ((Item)this.delegate).isNode();
    }

    public boolean isNew() {
        return ((Item)this.delegate).isNew();
    }

    public boolean isModified() {
        return ((Item)this.delegate).isModified();
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        return ((Item)this.delegate).isSame(this.mountSession.unwrap(otherItem));
    }

    public void accept(final ItemVisitor visitor) throws RepositoryException {
        ((Item)this.delegate).accept(new ItemVisitor(){

            public void visit(Property property) throws RepositoryException {
                visitor.visit(ProxyItem.this.mountSession.wrap(property));
            }

            public void visit(Node node) throws RepositoryException {
                visitor.visit(ProxyItem.this.mountSession.wrap(node));
            }
        });
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.mountSession.save();
    }

    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        this.mountSession.refresh(this.getPath(), (Item)this.delegate, keepChanges);
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.mountSession.removeItem(this.getPath());
    }
}

