/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.subsystems.impl;

import java.io.IOException;
import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factories.subsystems.impl.StartSubsystemTask;
import org.osgi.service.subsystem.Subsystem;

public class InstallSubsystemTask
extends InstallTask {
    private static final String INSTALL_ORDER = "53-";
    private final Subsystem rootSubsystem;

    public InstallSubsystemTask(TaskResourceGroup grp, Subsystem rootSubsystem) {
        super(grp);
        this.rootSubsystem = rootSubsystem;
    }

    public void execute(InstallationContext ctx) {
        TaskResource tr = this.getResource();
        ctx.log("Installing new subsystem from {}", new Object[]{tr});
        try {
            Subsystem sub = this.rootSubsystem.install(tr.getURL(), tr.getInputStream());
            ctx.addTaskToCurrentCycle((InstallTask)new StartSubsystemTask(this.getResourceGroup(), sub));
            ctx.log("Installed new subsystem {}", new Object[]{sub});
        }
        catch (IOException e) {
            ctx.log("Unable to install subsystem {} : {}", new Object[]{tr, e});
            ctx.addTaskToCurrentCycle((InstallTask)new ChangeStateTask(this.getResourceGroup(), ResourceState.IGNORED));
        }
    }

    public String getSortKey() {
        return INSTALL_ORDER + this.getResource().getURL();
    }
}

