/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngFilterType;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.PngFilterHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PngtasticFilterHandler
implements PngFilterHandler {
    private final Logger log;

    public PngtasticFilterHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void applyFiltering(PngFilterType filterType, List<byte[]> scanlines, int sampleBitCount) {
        int scanlineLength = scanlines.get(0).length;
        byte[] previousRow = new byte[scanlineLength];
        for (byte[] scanline : scanlines) {
            if (filterType != null) {
                scanline[0] = filterType.getValue();
            }
            byte[] previous = (byte[])scanline.clone();
            try {
                this.filter(scanline, previousRow, sampleBitCount);
            }
            catch (PngException e) {
                this.log.error("Error during filtering: %s", e.getMessage());
            }
            previousRow = previous;
        }
    }

    @Override
    public void applyAdaptiveFiltering(PngByteArrayOutputStream inflatedImageData, List<byte[]> scanlines, Map<PngFilterType, List<byte[]>> filteredScanLines, int sampleSize) throws IOException {
        for (int s = 0; s < scanlines.size(); ++s) {
            long bestSum = Long.MAX_VALUE;
            PngFilterType bestFilterType = null;
            for (Map.Entry<PngFilterType, List<byte[]>> entry : filteredScanLines.entrySet()) {
                long sum = 0L;
                byte[] scanline = entry.getValue().get(s);
                for (int i = 1; i < scanline.length; ++i) {
                    sum += (long)Math.abs(scanline[i]);
                }
                if (sum >= bestSum) continue;
                bestFilterType = entry.getKey();
                bestSum = sum;
            }
            if (bestFilterType == null) continue;
            scanlines.get((int)s)[0] = bestFilterType.getValue();
        }
        this.applyFiltering(null, scanlines, sampleSize);
    }

    @Override
    public void filter(byte[] line, byte[] previousLine, int sampleBitCount) throws PngException {
        PngFilterType filterType = PngFilterType.forValue(line[0]);
        line[0] = 0;
        PngFilterType previousFilterType = PngFilterType.forValue(previousLine[0]);
        previousLine[0] = 0;
        switch (filterType) {
            case NONE: {
                break;
            }
            case SUB: {
                byte[] original = (byte[])line.clone();
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(original[x] - (a < 0 ? (byte)0 : original[a]));
                    ++x;
                    ++a;
                }
                break;
            }
            case UP: {
                for (int x = 1; x < line.length; ++x) {
                    line[x] = (byte)(line[x] - previousLine[x]);
                }
                break;
            }
            case AVERAGE: {
                byte[] original = (byte[])line.clone();
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(original[x] - ((0xFF & original[a < 0 ? 0 : a]) + (0xFF & previousLine[x])) / 2);
                    ++x;
                    ++a;
                }
                break;
            }
            case PAETH: {
                byte[] original = (byte[])line.clone();
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    int result = this.paethPredictor(original, previousLine, x, a);
                    line[x] = (byte)(original[x] - result);
                    ++x;
                    ++a;
                }
                break;
            }
            default: {
                throw new PngException("Unrecognized filter type " + (Object)((Object)filterType));
            }
        }
        line[0] = filterType.getValue();
        previousLine[0] = previousFilterType.getValue();
    }

    @Override
    public void deFilter(byte[] line, byte[] previousLine, int sampleBitCount) throws PngException {
        PngFilterType filterType = PngFilterType.forValue(line[0]);
        line[0] = 0;
        PngFilterType previousFilterType = PngFilterType.forValue(previousLine[0]);
        previousLine[0] = 0;
        switch (filterType) {
            case SUB: {
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(line[x] + (a < 0 ? (byte)0 : line[a]));
                    ++x;
                    ++a;
                }
                break;
            }
            case UP: {
                for (int x = 1; x < line.length; ++x) {
                    line[x] = (byte)(line[x] + previousLine[x]);
                }
                break;
            }
            case AVERAGE: {
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int a = previous;
                while (x < line.length) {
                    line[x] = (byte)(line[x] + ((0xFF & (a < 0 ? 0 : line[a])) + (0xFF & previousLine[x])) / 2);
                    ++x;
                    ++a;
                }
                break;
            }
            case PAETH: {
                int previous = -(Math.max(1, sampleBitCount / 8) - 1);
                int x = 1;
                int xp = previous;
                while (x < line.length) {
                    int result = this.paethPredictor(line, previousLine, x, xp);
                    line[x] = (byte)(line[x] + result);
                    ++x;
                    ++xp;
                }
                break;
            }
        }
        line[0] = filterType.getValue();
        previousLine[0] = previousFilterType.getValue();
    }

    private int paethPredictor(byte[] line, byte[] previousLine, int x, int xp) {
        int pc;
        int a = 0xFF & (xp < 0 ? 0 : line[xp]);
        int b = 0xFF & previousLine[x];
        int c = 0xFF & (xp < 0 ? 0 : previousLine[xp]);
        int p = a + b - c;
        int pa = p >= a ? p - a : -(p - a);
        int pb = p >= b ? p - b : -(p - b);
        int n = pc = p >= c ? p - c : -(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        return pb <= pc ? b : c;
    }
}

