/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonObjectImpl;
import org.apache.johnzon.core.JsonStringImpl;

class JsonObjectBuilderImpl
implements JsonObjectBuilder,
Serializable {
    private Map<String, JsonValue> tmpMap;

    JsonObjectBuilderImpl() {
    }

    @Override
    public JsonObjectBuilder add(String name, JsonValue value) {
        this.putValue(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, String value) {
        this.putValue(name, new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigInteger value) {
        this.putValue(name, new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.putValue(name, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, int value) {
        this.putValue(name, new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, long value) {
        this.putValue(name, new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, double value) {
        this.putValue(name, new JsonDoubleImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, boolean value) {
        this.putValue(name, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonObjectBuilder addNull(String name) {
        this.putValue(name, JsonValue.NULL);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        this.putValue(name, builder.build());
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        this.putValue(name, builder.build());
        return this;
    }

    private void putValue(String name, JsonValue value) {
        if (name == null || value == null) {
            throw JsonObjectBuilderImpl.npe();
        }
        if (this.tmpMap == null) {
            this.tmpMap = new LinkedHashMap<String, JsonValue>();
        }
        this.tmpMap.put(name, value);
    }

    private static NullPointerException npe() {
        return new NullPointerException("name or value/builder must not be null");
    }

    @Override
    public JsonObject build() {
        if (this.tmpMap == null) {
            return new JsonObjectImpl(Collections.EMPTY_MAP);
        }
        Map<String, JsonValue> dump = Collections.unmodifiableMap(this.tmpMap);
        this.tmpMap = null;
        return new JsonObjectImpl(dump);
    }
}

