/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl.launchers;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.launcher.impl.VariableSubstitutor;
import org.apache.sling.feature.launcher.impl.launchers.FrameworkRunner;
import org.apache.sling.feature.launcher.spi.Launcher;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.LauncherRunContext;

@ServiceProvider(value=Launcher.class)
public class FrameworkLauncher
implements Launcher {
    private Feature feature;

    @Override
    public void prepare(LauncherPrepareContext context, ArtifactId frameworkId, Feature app) throws Exception {
        context.addAppJar(context.getArtifactFile(frameworkId));
        this.feature = app;
    }

    @Override
    public int run(LauncherRunContext context, ClassLoader cl) throws Exception {
        VariableSubstitutor vs = new VariableSubstitutor(context);
        HashMap properties = new HashMap();
        context.getFrameworkProperties().forEach((key, value) -> properties.put(key, vs.replace((String)value).replace("{dollar}", "$")));
        if (context.getLogger().isDebugEnabled()) {
            context.getLogger().debug("Bundles:");
            for (Integer n : context.getBundleMap().keySet()) {
                context.getLogger().debug("-- Start Level {}", (Object)n);
                for (URL f : context.getBundleMap().get(n)) {
                    context.getLogger().debug("  - {}", (Object)f);
                }
            }
            context.getLogger().debug("Settings: ");
            for (Map.Entry entry : properties.entrySet()) {
                context.getLogger().debug("- {}={}", entry.getKey(), entry.getValue());
            }
            context.getLogger().debug("Configurations: ");
            for (Object[] objectArray : context.getConfigurations()) {
                if (objectArray[1] != null) {
                    context.getLogger().debug("- Factory {} - {}", objectArray[1], objectArray[0]);
                    continue;
                }
                context.getLogger().debug("- {}", objectArray[0]);
            }
            context.getLogger().debug("");
        }
        Class<?> runnerClass = cl.loadClass(this.getFrameworkRunnerClass());
        Constructor<?> constructor = runnerClass.getDeclaredConstructor(Map.class, Map.class, List.class, List.class);
        constructor.setAccessible(true);
        Callable restart = (Callable)constructor.newInstance(properties, context.getBundleMap(), context.getConfigurations(), context.getInstallableArtifacts());
        this.setOptionalSupplier(restart, "setFeatureSupplier", new Supplier<Object>(){

            @Override
            public Object get() {
                String string;
                StringWriter writer = new StringWriter();
                try {
                    FeatureJSONWriter.write((Writer)writer, (Feature)FrameworkLauncher.this.feature);
                    writer.flush();
                    string = writer.toString();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                writer.close();
                return string;
            }
        });
        this.setOptionalBiConsumer(restart, "setBundleReporter", new BiConsumer<URL, Map<String, String>>(){

            @Override
            public void accept(URL url, Map<String, String> values) {
                String urlString = url.toString();
                for (Artifact a : FrameworkLauncher.this.feature.getBundles()) {
                    if (!urlString.equals(a.getMetadata().get(URL.class.getName()))) continue;
                    for (Map.Entry<String, String> entry : values.entrySet()) {
                        a.getMetadata().put(entry.getKey(), entry.getValue());
                    }
                }
            }
        });
        return (Integer)restart.call();
    }

    protected String getFrameworkRunnerClass() {
        return FrameworkRunner.class.getName();
    }

    private void setOptionalSupplier(Object restart, String name, Supplier<Object> supplier) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Method setSupplier = restart.getClass().getMethod(name, Supplier.class);
            setSupplier.setAccessible(true);
            setSupplier.invoke(restart, supplier);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void setOptionalBiConsumer(Object restart, String name, BiConsumer consumer) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Method setMethod = restart.getClass().getMethod(name, BiConsumer.class);
            setMethod.setAccessible(true);
            setMethod.invoke(restart, consumer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

