/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.Collections;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.AclGroupBase;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RemoveAcePaths
extends AclGroupBase {
    private final List<String> paths;

    public RemoveAcePaths(List<String> paths, List<AclLine> lines) {
        super(lines, Collections.emptyList());
        this.paths = Collections.unmodifiableList(paths);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.paths);
        sb.append(super.getParametersDescription());
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        String topline = String.format("remove ACE on %s%n", RemoveAcePaths.pathsToString(this.paths));
        return this.asRepoInit(topline, false);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitRemoveAcePaths(this);
    }
}

