/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.apiregions.impl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sling.feature.apiregions.impl.RegionConfiguration;
import org.apache.sling.feature.apiregions.impl.RegionEnforcer;
import org.apache.sling.feature.apiregions.impl.RegionPrinter;
import org.apache.sling.feature.apiregions.impl.ResolverHookImpl;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Header(name="ExtensionBundle-Activator", value="${@class}")
public class Activator
implements BundleActivator,
FrameworkListener {
    static final String CONFIG_ADMIN_PKG_NAME = "org.osgi.service.cm";
    static final String MANAGED_SERVICE_CLASS_NAME = "org.osgi.service.cm.ManagedService";
    static final String CONFIG_ADMIN_CLASS_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    static final String CFG_LISTENER_CLASS_NAME = "org.osgi.service.cm.SynchronousConfigurationListener";
    static final String CFG_EVENT_CLASS_NAME = "org.osgi.service.cm.ConfigurationEvent";
    static final String CFG_CLASS_NAME = "org.osgi.service.cm.Configuration";
    static final String FACTORY_PID = "org.apache.sling.feature.apiregions.factory";
    static final String REGIONS_PROPERTY_NAME = "org.apache.sling.feature.apiregions.regions";
    static final Logger LOG = Logger.getLogger(ResolverHookImpl.class.getName());
    BundleContext bundleContext;
    ServiceRegistration<ResolverHookFactory> hookRegistration;
    ServiceRegistration<RegionPrinter> webconsoleRegistration;
    RegionConfiguration configuration;
    ServiceTracker<Object, Object> configAdminTracker;

    public synchronized void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.createConfiguration();
        this.registerHook();
        this.registerWebconsoleStatus();
        this.configAdminTracker = new ServiceTracker(context, CONFIG_ADMIN_CLASS_NAME, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

            public Object addingService(ServiceReference<Object> reference) {
                Object cfgAdmin = Activator.this.bundleContext.getService(reference);
                if (cfgAdmin != null) {
                    return Activator.this.registerConfigurationListener(cfgAdmin);
                }
                return null;
            }

            public void modifiedService(ServiceReference<Object> reference, Object reg) {
            }

            public void removedService(ServiceReference<Object> reference, Object reg) {
                if (reg != null) {
                    ((ServiceRegistration)reg).unregister();
                }
            }
        });
        this.configAdminTracker.open();
        context.addFrameworkListener((FrameworkListener)this);
    }

    public synchronized void stop(BundleContext context) throws Exception {
        if (this.configuration != null) {
            this.configuration.storeLocationToConfigMap(context);
        }
        if (this.configAdminTracker != null) {
            this.configAdminTracker.close();
        }
    }

    private void createConfiguration() {
        try {
            this.configuration = new RegionConfiguration(this.bundleContext);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Problem activating API Regions runtime enforcement component", e);
        }
    }

    synchronized void registerHook() {
        if (this.hookRegistration != null) {
            return;
        }
        if (this.bundleContext.getProperty(REGIONS_PROPERTY_NAME) == null) {
            LOG.log(Level.WARNING, "API Regions not enabled. To enable set framework property: org.apache.sling.feature.apiregions.regions");
            return;
        }
        RegionEnforcer enforcer = new RegionEnforcer(this.configuration);
        this.hookRegistration = this.bundleContext.registerService(ResolverHookFactory.class, (Object)enforcer, this.configuration.getRegistrationProperties());
    }

    synchronized void registerWebconsoleStatus() {
        if (this.webconsoleRegistration != null) {
            return;
        }
        LOG.info("Registering region printer");
        RegionPrinter printer = new RegionPrinter(this.bundleContext, this.configuration);
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("felix.webconsole.label", "feature_apiregions");
        ((Dictionary)serviceProps).put("felix.webconsole.title", "Sling Feature - API Regions");
        ((Dictionary)serviceProps).put("felix.webconsole.configprinter.modes", "always");
        this.webconsoleRegistration = this.bundleContext.registerService(RegionPrinter.class, (Object)printer, serviceProps);
    }

    synchronized void unregisterHook() {
        if (this.hookRegistration != null) {
            this.hookRegistration.unregister();
            this.hookRegistration = null;
        }
    }

    synchronized void unregisterWebconsoleStatus() {
        if (this.webconsoleRegistration != null) {
            this.webconsoleRegistration.unregister();
            this.webconsoleRegistration = null;
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.bundleContext.removeFrameworkListener((FrameworkListener)this);
            FrameworkWiring fw = (FrameworkWiring)this.bundleContext.getBundle().adapt(FrameworkWiring.class);
            if (fw == null) {
                LOG.log(Level.WARNING, "The API Regions runtime fragment is not attached to the system bundle.");
                return;
            }
            Requirement cmReq = Activator.createCMPackageRequirement();
            Collection providers = fw.findProviders(cmReq);
            for (BundleCapability cap : providers) {
                if (!this.registerManagedService(cap)) continue;
                return;
            }
            LOG.log(Level.INFO, "No Configuration Admin API available");
        }
    }

    private boolean registerManagedService(BundleCapability cap) {
        try {
            ClassLoader loader = cap.getRevision().getWiring().getClassLoader();
            final Class<?> msClass = loader.loadClass(MANAGED_SERVICE_CLASS_NAME);
            Object ms = Proxy.newProxyInstance(loader, new Class[]{msClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Class<?> mdDecl = method.getDeclaringClass();
                    if (mdDecl.equals(Object.class)) {
                        switch (method.getName()) {
                            case "equals": {
                                return proxy == args[0];
                            }
                            case "hashCode": {
                                return System.identityHashCode(proxy);
                            }
                            case "toString": {
                                return "Proxy for " + msClass;
                            }
                        }
                        throw new UnsupportedOperationException("Method " + method + " not supported on proxy for " + msClass);
                    }
                    if ("updated".equals(method.getName()) && args.length == 1) {
                        Object arg = args[0];
                        if (arg == null) {
                            Activator.this.registerHook();
                            Activator.this.registerWebconsoleStatus();
                        } else if (arg instanceof Dictionary) {
                            Dictionary props = (Dictionary)args[0];
                            Object disabled = props.get("disable");
                            if ("true".equals(disabled)) {
                                Activator.this.unregisterHook();
                                Activator.this.unregisterWebconsoleStatus();
                            } else {
                                Activator.this.registerHook();
                                Activator.this.registerWebconsoleStatus();
                            }
                        }
                    }
                    return null;
                }
            });
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", this.getClass().getPackage().getName());
            this.bundleContext.registerService(MANAGED_SERVICE_CLASS_NAME, ms, props);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Problem attempting to register ManagedService from " + cap, e);
            return false;
        }
    }

    private ServiceRegistration<?> registerConfigurationListener(final Object cfgAdmin) {
        try {
            final Class<?> listenerClass = cfgAdmin.getClass().getClassLoader().loadClass(CFG_LISTENER_CLASS_NAME);
            Class<?> eventClass = cfgAdmin.getClass().getClassLoader().loadClass(CFG_EVENT_CLASS_NAME);
            final Method eventGetTypeMethod = eventClass.getMethod("getType", new Class[0]);
            final Method eventGetFactoryPidMethod = eventClass.getDeclaredMethod("getFactoryPid", new Class[0]);
            final Method eventGetPidMethod = eventClass.getDeclaredMethod("getPid", new Class[0]);
            final Method caGetConfigMethod = cfgAdmin.getClass().getDeclaredMethod("getConfiguration", String.class, String.class);
            Method caListConfigcMethod = cfgAdmin.getClass().getDeclaredMethod("listConfigurations", String.class);
            Class<?> cfgClass = cfgAdmin.getClass().getClassLoader().loadClass(CFG_CLASS_NAME);
            final Method cfgGetPropertiesMethod = cfgClass.getDeclaredMethod("getProperties", new Class[0]);
            Method cfgGetPidMethod = cfgClass.getDeclaredMethod("getPid", new Class[0]);
            Object msf = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object event;
                    String factoryPid;
                    Class<?> mdDecl = method.getDeclaringClass();
                    if (mdDecl.equals(Object.class)) {
                        switch (method.getName()) {
                            case "equals": {
                                return proxy == args[0];
                            }
                            case "hashCode": {
                                return System.identityHashCode(proxy);
                            }
                            case "toString": {
                                return "Proxy for " + listenerClass;
                            }
                        }
                        throw new UnsupportedOperationException("Method " + method + " not supported on proxy for " + listenerClass);
                    }
                    if ("configurationEvent".equals(method.getName()) && args.length == 1 && Activator.FACTORY_PID.equals(factoryPid = (String)eventGetFactoryPidMethod.invoke(event = args[0], (Object[])null))) {
                        String pid = (String)eventGetPidMethod.invoke(event, (Object[])null);
                        Object eventType = eventGetTypeMethod.invoke(event, (Object[])null);
                        if (eventType.equals(1)) {
                            Object cfg = caGetConfigMethod.invoke(cfgAdmin, pid, null);
                            Dictionary props = (Dictionary)cfgGetPropertiesMethod.invoke(cfg, (Object[])null);
                            Activator.this.configuration.setConfig(pid, props);
                        } else if (eventType.equals(2)) {
                            Activator.this.configuration.removeConfig(pid);
                        }
                    }
                    return null;
                }
            });
            ServiceRegistration reg = this.bundleContext.registerService(CFG_LISTENER_CLASS_NAME, msf, null);
            Object result = caListConfigcMethod.invoke(cfgAdmin, "(service.factoryPid=org.apache.sling.feature.apiregions.factory)");
            if (result != null) {
                for (int i = 0; i < Array.getLength(result); ++i) {
                    Object cfg = Array.get(result, i);
                    String pid = (String)cfgGetPidMethod.invoke(cfg, (Object[])null);
                    Dictionary props = (Dictionary)cfgGetPropertiesMethod.invoke(cfg, (Object[])null);
                    this.configuration.setConfig(pid, props);
                }
            }
            return reg;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Problem attempting to register configuration lister for " + cfgAdmin, e);
            return null;
        }
    }

    static Requirement createCMPackageRequirement() {
        Requirement cmReq = new Requirement(){

            public String getNamespace() {
                return "osgi.wiring.package";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.wiring.package=org.osgi.service.cm)");
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }

            public Resource getResource() {
                return null;
            }
        };
        return cmReq;
    }
}

