/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.cm.json.io.ConfigurationReader;
import org.apache.felix.cm.json.io.ConfigurationResource;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;

public class ConfigurationJSONReader {
    public static Configurations read(Reader reader, String location) throws IOException {
        try {
            ConfigurationJSONReader mr = new ConfigurationJSONReader();
            return mr.readConfigurations(location, reader);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IOException(e);
        }
    }

    Configurations readConfigurations(String location, Reader reader) throws IOException {
        final Configurations result = new Configurations();
        ConfigurationReader cfgReader = org.apache.felix.cm.json.io.Configurations.buildReader().withIdentifier(location).verifyAsBundleResource(true).withConfiguratorPropertyHandler(new ConfigurationReader.ConfiguratorPropertyHandler(){

            public void handleConfiguratorProperty(String pid, String property, Object value) {
                Configuration cfg = result.getConfiguration(pid);
                if (cfg == null) {
                    cfg = new Configuration(pid);
                    result.add(cfg);
                }
                cfg.getProperties().put(":configurator:".concat(property), value);
            }
        }).build(reader);
        ConfigurationResource rsrc = cfgReader.readConfigurationResource();
        for (Map.Entry entry : rsrc.getConfigurations().entrySet()) {
            Configuration cf = result.getConfiguration((String)entry.getKey());
            if (cf == null) {
                cf = new Configuration((String)entry.getKey());
                result.add(cf);
            }
            for (Map.Entry prop : ((Hashtable)entry.getValue()).entrySet()) {
                cf.getProperties().put((String)prop.getKey(), prop.getValue());
            }
        }
        return result;
    }
}

