/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.shared;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AgentId {
    private static final int SLING_ID_LENGTH = UUID.randomUUID().toString().length();
    private final String agentId;
    private final String agentName;
    private final String slingId;

    public AgentId(String agentId) {
        this.agentId = Objects.requireNonNull(agentId);
        this.slingId = this.checkSlingId(this.slingId(agentId));
        this.agentName = this.agentName(agentId);
    }

    public AgentId(String slingId, String agentName) {
        this.slingId = this.checkSlingId(Objects.requireNonNull(slingId));
        this.agentName = Objects.requireNonNull(agentName);
        this.agentId = this.agentId(slingId, agentName);
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getSlingId() {
        return this.slingId;
    }

    private String agentId(String slingId, String agentName) {
        return String.format("%s-%s", slingId, agentName);
    }

    private String agentName(String agentId) {
        return agentId.substring(SLING_ID_LENGTH + 1);
    }

    private String slingId(String agentId) {
        return agentId.substring(0, SLING_ID_LENGTH);
    }

    private String checkSlingId(String slingId) {
        if (slingId.length() != SLING_ID_LENGTH) {
            throw new IllegalArgumentException(String.format("Illegal slingId %s", slingId));
        }
        return slingId;
    }
}

