/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceEventDistributionTrigger
implements DistributionTrigger {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final String path;
    private final Map<String, ServiceRegistration<EventHandler>> registrations = new ConcurrentHashMap<String, ServiceRegistration<EventHandler>>();

    public ResourceEventDistributionTrigger(String path, BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Invalid bundle context");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path is required");
        }
        this.bundleContext = bundleContext;
        this.path = path;
    }

    public void enable() {
    }

    public void disable() {
        for (ServiceRegistration<EventHandler> serviceRegistration : this.registrations.values()) {
            serviceRegistration.unregister();
        }
        this.registrations.clear();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event.topics", new String[]{"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"});
        this.log.info("trigger agent {} on path '{}'", (Object)requestHandler, (Object)this.path);
        ((Dictionary)properties).put("event.filter", "(&(path=" + this.path + "/*) (!(" + "event.application" + "=*)))");
        ServiceRegistration triggerPathEventRegistration = this.bundleContext.registerService(EventHandler.class, (Object)new TriggerAgentEventListener(requestHandler), properties);
        if (triggerPathEventRegistration == null) {
            throw new DistributionException("cannot register event handler service for triggering agent");
        }
        this.registrations.put(requestHandler.toString(), (ServiceRegistration<EventHandler>)triggerPathEventRegistration);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        ServiceRegistration<EventHandler> serviceRegistration = this.registrations.get(requestHandler.toString());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class TriggerAgentEventListener
    implements EventHandler {
        private final DistributionRequestHandler requestHandler;

        public TriggerAgentEventListener(DistributionRequestHandler requestHandler) {
            this.requestHandler = requestHandler;
        }

        public void handleEvent(Event event) {
            DistributionRequestType action = "org/apache/sling/api/resource/Resource/REMOVED".equals(event.getTopic()) ? DistributionRequestType.DELETE : DistributionRequestType.ADD;
            ResourceEventDistributionTrigger.this.log.info("triggering distribution from event {}", (Object)event);
            for (String pn : event.getPropertyNames()) {
                ResourceEventDistributionTrigger.this.log.info("property {} : {}", (Object)pn, event.getProperty(pn));
            }
            Object pathProperty = event.getProperty("path");
            if (pathProperty != null) {
                String distributingPath = String.valueOf(pathProperty);
                this.requestHandler.handle(null, (DistributionRequest)new SimpleDistributionRequest(action, new String[]{distributingPath}));
            }
        }
    }
}

