/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.queue.impl.simple;

import java.util.function.Consumer;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.impl.DistributionQueueProcessor;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDistributionQueueProcessor
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionQueue queue;
    private final DistributionQueueProcessor queueProcessor;
    private Consumer<DistributionQueueEntry> recordProcessingAttempt;

    public SimpleDistributionQueueProcessor(DistributionQueue queue, DistributionQueueProcessor queueProcessor, Consumer<DistributionQueueEntry> processingAttemptRecorder) {
        this.queue = queue;
        this.queueProcessor = queueProcessor;
        this.recordProcessingAttempt = null != processingAttemptRecorder ? processingAttemptRecorder : entry -> {};
    }

    @Override
    public void run() {
        try {
            DistributionQueueEntry entry;
            while ((entry = this.queue.getHead()) != null) {
                boolean wasRemoved;
                boolean wasProcessed = this.queueProcessor.process(this.queue.getName(), entry);
                boolean bl = wasProcessed ? this.queue.remove(entry.getId()) != null : (wasRemoved = false);
                if (wasProcessed && wasRemoved) {
                    this.log.debug("item {} processed and removed from the queue", (Object)entry.getItem());
                    continue;
                }
                this.log.warn("processing and removal of item {} failed; will reattempt", (Object)entry.getId());
                this.recordProcessingAttempt.accept(entry);
            }
        }
        catch (Exception e) {
            this.log.error("error while processing queue {}", (Throwable)e);
        }
    }
}

